/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public interface PathProcessor {
    default public long lastModified(Path path, long defValue) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (NoSuchFileException e) {
            return defValue;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public long size(Path path, long defValue) {
        try {
            return Files.size(path);
        }
        catch (NoSuchFileException e) {
            return defValue;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(Path var1, String var2) throws IOException;

    public void write(Path var1, InputStream var2) throws IOException;

    public void move(Path var1, Path var2) throws IOException;

    public void copy(Path var1, Path var2) throws IOException;

    public long copy(Path var1, Path var2, ProgressListener var3) throws IOException;

    public static interface ProgressListener {
        public void progressed(ByteBuffer var1) throws IOException;
    }
}

