/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.supplier;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultModelCacheFactory;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenArtifactRelocationSource;
import org.apache.maven.repository.internal.ModelCacheFactory;
import org.apache.maven.repository.internal.PluginsMetadataGeneratorFactory;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.apache.maven.repository.internal.relocation.DistributionManagementArtifactRelocationSource;
import org.apache.maven.repository.internal.relocation.UserPropertiesArtifactRelocationSource;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultChecksumProcessor;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultOfflineController;
import org.eclipse.aether.internal.impl.DefaultPathProcessor;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultRepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.DefaultTrackingFileManager;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.SparseDirectoryTrustedChecksumsSource;
import org.eclipse.aether.internal.impl.checksum.SummaryFileTrustedChecksumsSource;
import org.eclipse.aether.internal.impl.checksum.TrustedToProvidedChecksumsSourceAdapter;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector;
import org.eclipse.aether.internal.impl.collect.df.DfDependencyCollector;
import org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager;
import org.eclipse.aether.internal.impl.filter.GroupIdRemoteRepositoryFilterSource;
import org.eclipse.aether.internal.impl.filter.PrefixesRemoteRepositoryFilterSource;
import org.eclipse.aether.internal.impl.resolution.TrustedChecksumsArtifactResolverPostProcessor;
import org.eclipse.aether.internal.impl.synccontext.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NameMappers;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactoryImpl;
import org.eclipse.aether.internal.impl.transport.http.DefaultChecksumExtractor;
import org.eclipse.aether.internal.impl.transport.http.Nx2ChecksumExtractor;
import org.eclipse.aether.internal.impl.transport.http.XChecksumExtractor;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.eclipse.aether.named.providers.NoopNamedLockFactory;
import org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractorStrategy;
import org.eclipse.aether.spi.io.ChecksumProcessor;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transport.apache.ApacheTransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.VersionScheme;

public class RepositorySystemSupplier
implements Supplier<RepositorySystem> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private PathProcessor pathProcessor;
    private ChecksumProcessor checksumProcessor;
    private TrackingFileManager trackingFileManager;
    private LocalPathComposer localPathComposer;
    private LocalPathPrefixComposerFactory localPathPrefixComposerFactory;
    private RepositorySystemLifecycle repositorySystemLifecycle;
    private OfflineController offlineController;
    private UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private ChecksumPolicyProvider checksumPolicyProvider;
    private UpdateCheckManager updateCheckManager;
    private Map<String, NamedLockFactory> namedLockFactories;
    private Map<String, NameMapper> nameMappers;
    private NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory;
    private SyncContextFactory syncContextFactory;
    private Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories;
    private ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;
    private Map<String, RepositoryLayoutFactory> repositoryLayoutFactories;
    private RepositoryLayoutProvider repositoryLayoutProvider;
    private LocalRepositoryProvider localRepositoryProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private Map<String, RemoteRepositoryFilterSource> remoteRepositoryFilterSources;
    private RemoteRepositoryFilterManager remoteRepositoryFilterManager;
    private Map<String, RepositoryListener> repositoryListeners;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private Map<String, TrustedChecksumsSource> trustedChecksumsSources;
    private Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private Map<String, ChecksumExtractorStrategy> checksumExtractorStrategies;
    private ChecksumExtractor checksumExtractor;
    private Map<String, TransporterFactory> transporterFactories;
    private TransporterProvider transporterProvider;
    private BasicRepositoryConnectorFactory basicRepositoryConnectorFactory;
    private Map<String, RepositoryConnectorFactory> repositoryConnectorFactories;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private Installer installer;
    private Deployer deployer;
    private Map<String, DependencyCollectorDelegate> dependencyCollectorDelegates;
    private DependencyCollector dependencyCollector;
    private Map<String, ArtifactResolverPostProcessor> artifactResolverPostProcessors;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private VersionScheme versionScheme;
    private Map<String, MetadataGeneratorFactory> metadataGeneratorFactories;
    private LinkedHashMap<String, MavenArtifactRelocationSource> artifactRelocationSources;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ModelBuilder modelBuilder;
    private ModelCacheFactory modelCacheFactory;
    private RepositorySystem repositorySystem;

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Supplier is closed");
        }
    }

    public final PathProcessor getPathProcessor() {
        this.checkClosed();
        if (this.pathProcessor == null) {
            this.pathProcessor = this.createPathProcessor();
        }
        return this.pathProcessor;
    }

    protected PathProcessor createPathProcessor() {
        return new DefaultPathProcessor();
    }

    public final ChecksumProcessor getChecksumProcessor() {
        this.checkClosed();
        if (this.checksumProcessor == null) {
            this.checksumProcessor = this.createChecksumProcessor();
        }
        return this.checksumProcessor;
    }

    protected ChecksumProcessor createChecksumProcessor() {
        return new DefaultChecksumProcessor(this.getPathProcessor());
    }

    public final TrackingFileManager getTrackingFileManager() {
        this.checkClosed();
        if (this.trackingFileManager == null) {
            this.trackingFileManager = this.createTrackingFileManager();
        }
        return this.trackingFileManager;
    }

    protected TrackingFileManager createTrackingFileManager() {
        return new DefaultTrackingFileManager();
    }

    public final LocalPathComposer getLocalPathComposer() {
        this.checkClosed();
        if (this.localPathComposer == null) {
            this.localPathComposer = this.createLocalPathComposer();
        }
        return this.localPathComposer;
    }

    protected LocalPathComposer createLocalPathComposer() {
        return new DefaultLocalPathComposer();
    }

    public final LocalPathPrefixComposerFactory getLocalPathPrefixComposerFactory() {
        this.checkClosed();
        if (this.localPathPrefixComposerFactory == null) {
            this.localPathPrefixComposerFactory = this.createLocalPathPrefixComposerFactory();
        }
        return this.localPathPrefixComposerFactory;
    }

    protected LocalPathPrefixComposerFactory createLocalPathPrefixComposerFactory() {
        return new DefaultLocalPathPrefixComposerFactory();
    }

    public final RepositorySystemLifecycle getRepositorySystemLifecycle() {
        this.checkClosed();
        if (this.repositorySystemLifecycle == null) {
            this.repositorySystemLifecycle = this.createRepositorySystemLifecycle();
            this.repositorySystemLifecycle.addOnSystemEndedHandler(() -> this.closed.set(true));
        }
        return this.repositorySystemLifecycle;
    }

    protected RepositorySystemLifecycle createRepositorySystemLifecycle() {
        return new DefaultRepositorySystemLifecycle();
    }

    public final OfflineController getOfflineController() {
        this.checkClosed();
        if (this.offlineController == null) {
            this.offlineController = this.createOfflineController();
        }
        return this.offlineController;
    }

    protected OfflineController createOfflineController() {
        return new DefaultOfflineController();
    }

    public final UpdatePolicyAnalyzer getUpdatePolicyAnalyzer() {
        this.checkClosed();
        if (this.updatePolicyAnalyzer == null) {
            this.updatePolicyAnalyzer = this.createUpdatePolicyAnalyzer();
        }
        return this.updatePolicyAnalyzer;
    }

    protected UpdatePolicyAnalyzer createUpdatePolicyAnalyzer() {
        return new DefaultUpdatePolicyAnalyzer();
    }

    public final ChecksumPolicyProvider getChecksumPolicyProvider() {
        this.checkClosed();
        if (this.checksumPolicyProvider == null) {
            this.checksumPolicyProvider = this.createChecksumPolicyProvider();
        }
        return this.checksumPolicyProvider;
    }

    protected ChecksumPolicyProvider createChecksumPolicyProvider() {
        return new DefaultChecksumPolicyProvider();
    }

    public final UpdateCheckManager getUpdateCheckManager() {
        this.checkClosed();
        if (this.updateCheckManager == null) {
            this.updateCheckManager = this.createUpdateCheckManager();
        }
        return this.updateCheckManager;
    }

    protected UpdateCheckManager createUpdateCheckManager() {
        return new DefaultUpdateCheckManager(this.getTrackingFileManager(), this.getUpdatePolicyAnalyzer(), this.getPathProcessor());
    }

    public final Map<String, NamedLockFactory> getNamedLockFactories() {
        this.checkClosed();
        if (this.namedLockFactories == null) {
            this.namedLockFactories = this.createNamedLockFactories();
        }
        return this.namedLockFactories;
    }

    protected Map<String, NamedLockFactory> createNamedLockFactories() {
        HashMap<String, NamedLockFactory> result = new HashMap<String, NamedLockFactory>();
        result.put("noop", new NoopNamedLockFactory());
        result.put("rwlock-local", new LocalReadWriteLockNamedLockFactory());
        result.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        result.put("file-lock", new FileLockNamedLockFactory());
        return result;
    }

    public final Map<String, NameMapper> getNameMappers() {
        this.checkClosed();
        if (this.nameMappers == null) {
            this.nameMappers = this.createNameMappers();
        }
        return this.nameMappers;
    }

    protected Map<String, NameMapper> createNameMappers() {
        HashMap<String, NameMapper> result = new HashMap<String, NameMapper>();
        result.put("static", NameMappers.staticNameMapper());
        result.put("gav", NameMappers.gavNameMapper());
        result.put("discriminating", NameMappers.discriminatingNameMapper());
        result.put("file-gav", NameMappers.fileGavNameMapper());
        result.put("file-hgav", NameMappers.fileHashingGavNameMapper());
        return result;
    }

    public final NamedLockFactoryAdapterFactory getNamedLockFactoryAdapterFactory() {
        this.checkClosed();
        if (this.namedLockFactoryAdapterFactory == null) {
            this.namedLockFactoryAdapterFactory = this.createNamedLockFactoryAdapterFactory();
        }
        return this.namedLockFactoryAdapterFactory;
    }

    protected NamedLockFactoryAdapterFactory createNamedLockFactoryAdapterFactory() {
        return new NamedLockFactoryAdapterFactoryImpl(this.getNamedLockFactories(), this.getNameMappers(), this.getRepositorySystemLifecycle());
    }

    public final SyncContextFactory getSyncContextFactory() {
        this.checkClosed();
        if (this.syncContextFactory == null) {
            this.syncContextFactory = this.createSyncContextFactory();
        }
        return this.syncContextFactory;
    }

    protected SyncContextFactory createSyncContextFactory() {
        return new DefaultSyncContextFactory(this.getNamedLockFactoryAdapterFactory());
    }

    public final Map<String, ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        this.checkClosed();
        if (this.checksumAlgorithmFactories == null) {
            this.checksumAlgorithmFactories = this.createChecksumAlgorithmFactories();
        }
        return this.checksumAlgorithmFactories;
    }

    protected Map<String, ChecksumAlgorithmFactory> createChecksumAlgorithmFactories() {
        HashMap<String, ChecksumAlgorithmFactory> result = new HashMap<String, ChecksumAlgorithmFactory>();
        result.put("SHA-512", new Sha512ChecksumAlgorithmFactory());
        result.put("SHA-256", new Sha256ChecksumAlgorithmFactory());
        result.put("SHA-1", new Sha1ChecksumAlgorithmFactory());
        result.put("MD5", new Md5ChecksumAlgorithmFactory());
        return result;
    }

    public final ChecksumAlgorithmFactorySelector getChecksumAlgorithmFactorySelector() {
        this.checkClosed();
        if (this.checksumAlgorithmFactorySelector == null) {
            this.checksumAlgorithmFactorySelector = this.createChecksumAlgorithmFactorySelector();
        }
        return this.checksumAlgorithmFactorySelector;
    }

    protected ChecksumAlgorithmFactorySelector createChecksumAlgorithmFactorySelector() {
        return new DefaultChecksumAlgorithmFactorySelector(this.getChecksumAlgorithmFactories());
    }

    public final Map<String, RepositoryLayoutFactory> getRepositoryLayoutFactories() {
        this.checkClosed();
        if (this.repositoryLayoutFactories == null) {
            this.repositoryLayoutFactories = this.createRepositoryLayoutFactories();
        }
        return this.repositoryLayoutFactories;
    }

    protected Map<String, RepositoryLayoutFactory> createRepositoryLayoutFactories() {
        HashMap<String, RepositoryLayoutFactory> result = new HashMap<String, RepositoryLayoutFactory>();
        result.put("maven2", new Maven2RepositoryLayoutFactory(this.getChecksumAlgorithmFactorySelector()));
        return result;
    }

    public final RepositoryLayoutProvider getRepositoryLayoutProvider() {
        this.checkClosed();
        if (this.repositoryLayoutProvider == null) {
            this.repositoryLayoutProvider = this.createRepositoryLayoutProvider();
        }
        return this.repositoryLayoutProvider;
    }

    protected RepositoryLayoutProvider createRepositoryLayoutProvider() {
        return new DefaultRepositoryLayoutProvider(this.getRepositoryLayoutFactories());
    }

    public final LocalRepositoryProvider getLocalRepositoryProvider() {
        this.checkClosed();
        if (this.localRepositoryProvider == null) {
            this.localRepositoryProvider = this.createLocalRepositoryProvider();
        }
        return this.localRepositoryProvider;
    }

    protected LocalRepositoryProvider createLocalRepositoryProvider() {
        LocalPathComposer localPathComposer = this.getLocalPathComposer();
        HashMap<String, LocalRepositoryManagerFactory> localRepositoryProviders = new HashMap<String, LocalRepositoryManagerFactory>(2);
        localRepositoryProviders.put("simple", new SimpleLocalRepositoryManagerFactory(localPathComposer));
        localRepositoryProviders.put("enhanced", new EnhancedLocalRepositoryManagerFactory(localPathComposer, this.getTrackingFileManager(), this.getLocalPathPrefixComposerFactory()));
        return new DefaultLocalRepositoryProvider(localRepositoryProviders);
    }

    public final RemoteRepositoryManager getRemoteRepositoryManager() {
        this.checkClosed();
        if (this.remoteRepositoryManager == null) {
            this.remoteRepositoryManager = this.createRemoteRepositoryManager();
        }
        return this.remoteRepositoryManager;
    }

    protected RemoteRepositoryManager createRemoteRepositoryManager() {
        return new DefaultRemoteRepositoryManager(this.getUpdatePolicyAnalyzer(), this.getChecksumPolicyProvider());
    }

    public final Map<String, RemoteRepositoryFilterSource> getRemoteRepositoryFilterSources() {
        this.checkClosed();
        if (this.remoteRepositoryFilterSources == null) {
            this.remoteRepositoryFilterSources = this.createRemoteRepositoryFilterSources();
        }
        return this.remoteRepositoryFilterSources;
    }

    protected Map<String, RemoteRepositoryFilterSource> createRemoteRepositoryFilterSources() {
        HashMap<String, RemoteRepositoryFilterSource> result = new HashMap<String, RemoteRepositoryFilterSource>();
        result.put("groupId", new GroupIdRemoteRepositoryFilterSource(this.getRepositorySystemLifecycle()));
        result.put("prefixes", new PrefixesRemoteRepositoryFilterSource(this.getRepositoryLayoutProvider()));
        return result;
    }

    public final RemoteRepositoryFilterManager getRemoteRepositoryFilterManager() {
        this.checkClosed();
        if (this.remoteRepositoryFilterManager == null) {
            this.remoteRepositoryFilterManager = this.createRemoteRepositoryFilterManager();
        }
        return this.remoteRepositoryFilterManager;
    }

    protected RemoteRepositoryFilterManager createRemoteRepositoryFilterManager() {
        return new DefaultRemoteRepositoryFilterManager(this.getRemoteRepositoryFilterSources());
    }

    public final Map<String, RepositoryListener> getRepositoryListeners() {
        this.checkClosed();
        if (this.repositoryListeners == null) {
            this.repositoryListeners = this.createRepositoryListeners();
        }
        return this.repositoryListeners;
    }

    protected Map<String, RepositoryListener> createRepositoryListeners() {
        return new HashMap<String, RepositoryListener>();
    }

    public final RepositoryEventDispatcher getRepositoryEventDispatcher() {
        this.checkClosed();
        if (this.repositoryEventDispatcher == null) {
            this.repositoryEventDispatcher = this.createRepositoryEventDispatcher();
        }
        return this.repositoryEventDispatcher;
    }

    protected RepositoryEventDispatcher createRepositoryEventDispatcher() {
        return new DefaultRepositoryEventDispatcher(this.getRepositoryListeners());
    }

    public final Map<String, TrustedChecksumsSource> getTrustedChecksumsSources() {
        this.checkClosed();
        if (this.trustedChecksumsSources == null) {
            this.trustedChecksumsSources = this.createTrustedChecksumsSources();
        }
        return this.trustedChecksumsSources;
    }

    protected Map<String, TrustedChecksumsSource> createTrustedChecksumsSources() {
        HashMap<String, TrustedChecksumsSource> result = new HashMap<String, TrustedChecksumsSource>();
        result.put("sparseDirectory", new SparseDirectoryTrustedChecksumsSource(this.getChecksumProcessor(), this.getLocalPathComposer()));
        result.put("summaryFile", new SummaryFileTrustedChecksumsSource(this.getLocalPathComposer(), this.getRepositorySystemLifecycle()));
        return result;
    }

    public final Map<String, ProvidedChecksumsSource> getProvidedChecksumsSources() {
        this.checkClosed();
        if (this.providedChecksumsSources == null) {
            this.providedChecksumsSources = this.createProvidedChecksumsSources();
        }
        return this.providedChecksumsSources;
    }

    protected Map<String, ProvidedChecksumsSource> createProvidedChecksumsSources() {
        HashMap<String, ProvidedChecksumsSource> result = new HashMap<String, ProvidedChecksumsSource>();
        result.put("trusted2provided", new TrustedToProvidedChecksumsSourceAdapter(this.getTrustedChecksumsSources()));
        return result;
    }

    public final Map<String, ChecksumExtractorStrategy> getChecksumExtractorStrategies() {
        this.checkClosed();
        if (this.checksumExtractorStrategies == null) {
            this.checksumExtractorStrategies = this.createChecksumExtractorStrategies();
        }
        return this.checksumExtractorStrategies;
    }

    protected Map<String, ChecksumExtractorStrategy> createChecksumExtractorStrategies() {
        HashMap<String, ChecksumExtractorStrategy> result = new HashMap<String, ChecksumExtractorStrategy>();
        result.put("xChecksum", new XChecksumExtractor());
        result.put("nx2", new Nx2ChecksumExtractor());
        return result;
    }

    public final ChecksumExtractor getChecksumExtractor() {
        this.checkClosed();
        if (this.checksumExtractor == null) {
            this.checksumExtractor = this.createChecksumExtractor();
        }
        return this.checksumExtractor;
    }

    protected ChecksumExtractor createChecksumExtractor() {
        return new DefaultChecksumExtractor(this.getChecksumExtractorStrategies());
    }

    public final Map<String, TransporterFactory> getTransporterFactories() {
        this.checkClosed();
        if (this.transporterFactories == null) {
            this.transporterFactories = this.createTransporterFactories();
        }
        return this.transporterFactories;
    }

    protected Map<String, TransporterFactory> createTransporterFactories() {
        HashMap<String, TransporterFactory> result = new HashMap<String, TransporterFactory>();
        result.put("file", new FileTransporterFactory());
        result.put("apache", new ApacheTransporterFactory(this.getChecksumExtractor()));
        return result;
    }

    public final TransporterProvider getTransporterProvider() {
        this.checkClosed();
        if (this.transporterProvider == null) {
            this.transporterProvider = this.createTransporterProvider();
        }
        return this.transporterProvider;
    }

    protected TransporterProvider createTransporterProvider() {
        return new DefaultTransporterProvider(this.getTransporterFactories());
    }

    public final BasicRepositoryConnectorFactory getBasicRepositoryConnectorFactory() {
        this.checkClosed();
        if (this.basicRepositoryConnectorFactory == null) {
            this.basicRepositoryConnectorFactory = this.createBasicRepositoryConnectorFactory();
        }
        return this.basicRepositoryConnectorFactory;
    }

    protected BasicRepositoryConnectorFactory createBasicRepositoryConnectorFactory() {
        return new BasicRepositoryConnectorFactory(this.getTransporterProvider(), this.getRepositoryLayoutProvider(), this.getChecksumPolicyProvider(), this.getChecksumProcessor(), this.getProvidedChecksumsSources());
    }

    public final Map<String, RepositoryConnectorFactory> getRepositoryConnectorFactories() {
        this.checkClosed();
        if (this.repositoryConnectorFactories == null) {
            this.repositoryConnectorFactories = this.createRepositoryConnectorFactories();
        }
        return this.repositoryConnectorFactories;
    }

    protected Map<String, RepositoryConnectorFactory> createRepositoryConnectorFactories() {
        HashMap<String, RepositoryConnectorFactory> result = new HashMap<String, RepositoryConnectorFactory>();
        result.put("basic", this.getBasicRepositoryConnectorFactory());
        return result;
    }

    public final RepositoryConnectorProvider getRepositoryConnectorProvider() {
        this.checkClosed();
        if (this.repositoryConnectorProvider == null) {
            this.repositoryConnectorProvider = this.createRepositoryConnectorProvider();
        }
        return this.repositoryConnectorProvider;
    }

    protected RepositoryConnectorProvider createRepositoryConnectorProvider() {
        return new DefaultRepositoryConnectorProvider(this.getRepositoryConnectorFactories(), this.getRemoteRepositoryFilterManager());
    }

    public final Installer getInstaller() {
        this.checkClosed();
        if (this.installer == null) {
            this.installer = this.createInstaller();
        }
        return this.installer;
    }

    protected Installer createInstaller() {
        return new DefaultInstaller(this.getPathProcessor(), this.getRepositoryEventDispatcher(), this.getMetadataGeneratorFactories(), this.getSyncContextFactory());
    }

    public final Deployer getDeployer() {
        this.checkClosed();
        if (this.deployer == null) {
            this.deployer = this.createDeployer();
        }
        return this.deployer;
    }

    protected Deployer createDeployer() {
        return new DefaultDeployer(this.getPathProcessor(), this.getRepositoryEventDispatcher(), this.getRepositoryConnectorProvider(), this.getRemoteRepositoryManager(), this.getUpdateCheckManager(), this.getMetadataGeneratorFactories(), this.getSyncContextFactory(), this.getOfflineController());
    }

    public final Map<String, DependencyCollectorDelegate> getDependencyCollectorDelegates() {
        this.checkClosed();
        if (this.dependencyCollectorDelegates == null) {
            this.dependencyCollectorDelegates = this.createDependencyCollectorDelegates();
        }
        return this.dependencyCollectorDelegates;
    }

    protected Map<String, DependencyCollectorDelegate> createDependencyCollectorDelegates() {
        RemoteRepositoryManager remoteRepositoryManager = this.getRemoteRepositoryManager();
        ArtifactDescriptorReader artifactDescriptorReader = this.getArtifactDescriptorReader();
        VersionRangeResolver versionRangeResolver = this.getVersionRangeResolver();
        HashMap<String, DependencyCollectorDelegate> result = new HashMap<String, DependencyCollectorDelegate>();
        result.put("df", new DfDependencyCollector(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver));
        result.put("bf", new BfDependencyCollector(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver));
        return result;
    }

    public final DependencyCollector getDependencyCollector() {
        this.checkClosed();
        if (this.dependencyCollector == null) {
            this.dependencyCollector = this.createDependencyCollector();
        }
        return this.dependencyCollector;
    }

    protected DependencyCollector createDependencyCollector() {
        return new DefaultDependencyCollector(this.getDependencyCollectorDelegates());
    }

    public final Map<String, ArtifactResolverPostProcessor> getArtifactResolverPostProcessors() {
        this.checkClosed();
        if (this.artifactResolverPostProcessors == null) {
            this.artifactResolverPostProcessors = this.createArtifactResolverPostProcessors();
        }
        return this.artifactResolverPostProcessors;
    }

    protected Map<String, ArtifactResolverPostProcessor> createArtifactResolverPostProcessors() {
        HashMap<String, ArtifactResolverPostProcessor> result = new HashMap<String, ArtifactResolverPostProcessor>();
        result.put("trustedChecksums", new TrustedChecksumsArtifactResolverPostProcessor(this.getChecksumAlgorithmFactorySelector(), this.getTrustedChecksumsSources()));
        return result;
    }

    public final ArtifactResolver getArtifactResolver() {
        this.checkClosed();
        if (this.artifactResolver == null) {
            this.artifactResolver = this.createArtifactResolver();
        }
        return this.artifactResolver;
    }

    protected ArtifactResolver createArtifactResolver() {
        return new DefaultArtifactResolver(this.getPathProcessor(), this.getRepositoryEventDispatcher(), this.getVersionResolver(), this.getUpdateCheckManager(), this.getRepositoryConnectorProvider(), this.getRemoteRepositoryManager(), this.getSyncContextFactory(), this.getOfflineController(), this.getArtifactResolverPostProcessors(), this.getRemoteRepositoryFilterManager());
    }

    public final MetadataResolver getMetadataResolver() {
        this.checkClosed();
        if (this.metadataResolver == null) {
            this.metadataResolver = this.createMetadataResolver();
        }
        return this.metadataResolver;
    }

    protected MetadataResolver createMetadataResolver() {
        return new DefaultMetadataResolver(this.getRepositoryEventDispatcher(), this.getUpdateCheckManager(), this.getRepositoryConnectorProvider(), this.getRemoteRepositoryManager(), this.getSyncContextFactory(), this.getOfflineController(), this.getRemoteRepositoryFilterManager(), this.getPathProcessor());
    }

    public final VersionScheme getVersionScheme() {
        this.checkClosed();
        if (this.versionScheme == null) {
            this.versionScheme = this.createVersionScheme();
        }
        return this.versionScheme;
    }

    protected VersionScheme createVersionScheme() {
        return new GenericVersionScheme();
    }

    public final Map<String, MetadataGeneratorFactory> getMetadataGeneratorFactories() {
        this.checkClosed();
        if (this.metadataGeneratorFactories == null) {
            this.metadataGeneratorFactories = this.createMetadataGeneratorFactories();
        }
        return this.metadataGeneratorFactories;
    }

    protected Map<String, MetadataGeneratorFactory> createMetadataGeneratorFactories() {
        HashMap<String, MetadataGeneratorFactory> result = new HashMap<String, MetadataGeneratorFactory>();
        result.put("plugins", new PluginsMetadataGeneratorFactory());
        result.put("versions", new VersionsMetadataGeneratorFactory());
        result.put("snapshot", new SnapshotMetadataGeneratorFactory());
        return result;
    }

    public final LinkedHashMap<String, MavenArtifactRelocationSource> getMavenArtifactRelocationSources() {
        this.checkClosed();
        if (this.artifactRelocationSources == null) {
            this.artifactRelocationSources = this.createMavenArtifactRelocationSources();
        }
        return this.artifactRelocationSources;
    }

    protected LinkedHashMap<String, MavenArtifactRelocationSource> createMavenArtifactRelocationSources() {
        LinkedHashMap<String, MavenArtifactRelocationSource> result = new LinkedHashMap<String, MavenArtifactRelocationSource>();
        result.put("userProperties", new UserPropertiesArtifactRelocationSource());
        result.put("distributionManagement", new DistributionManagementArtifactRelocationSource());
        return result;
    }

    public final ArtifactDescriptorReader getArtifactDescriptorReader() {
        this.checkClosed();
        if (this.artifactDescriptorReader == null) {
            this.artifactDescriptorReader = this.createArtifactDescriptorReader();
        }
        return this.artifactDescriptorReader;
    }

    protected ArtifactDescriptorReader createArtifactDescriptorReader() {
        return new DefaultArtifactDescriptorReader(this.getRemoteRepositoryManager(), this.getVersionResolver(), this.getVersionRangeResolver(), this.getArtifactResolver(), this.getModelBuilder(), this.getRepositoryEventDispatcher(), this.getModelCacheFactory(), this.getMavenArtifactRelocationSources());
    }

    public final VersionResolver getVersionResolver() {
        this.checkClosed();
        if (this.versionResolver == null) {
            this.versionResolver = this.createVersionResolver();
        }
        return this.versionResolver;
    }

    protected VersionResolver createVersionResolver() {
        return new DefaultVersionResolver(this.getMetadataResolver(), this.getSyncContextFactory(), this.getRepositoryEventDispatcher());
    }

    public final VersionRangeResolver getVersionRangeResolver() {
        this.checkClosed();
        if (this.versionRangeResolver == null) {
            this.versionRangeResolver = this.createVersionRangeResolver();
        }
        return this.versionRangeResolver;
    }

    protected VersionRangeResolver createVersionRangeResolver() {
        return new DefaultVersionRangeResolver(this.getMetadataResolver(), this.getSyncContextFactory(), this.getRepositoryEventDispatcher(), this.getVersionScheme());
    }

    public final ModelBuilder getModelBuilder() {
        this.checkClosed();
        if (this.modelBuilder == null) {
            this.modelBuilder = this.createModelBuilder();
        }
        return this.modelBuilder;
    }

    protected ModelBuilder createModelBuilder() {
        return new DefaultModelBuilderFactory().newInstance();
    }

    public final ModelCacheFactory getModelCacheFactory() {
        this.checkClosed();
        if (this.modelCacheFactory == null) {
            this.modelCacheFactory = this.createModelCacheFactory();
        }
        return this.modelCacheFactory;
    }

    protected ModelCacheFactory createModelCacheFactory() {
        return new DefaultModelCacheFactory();
    }

    public final RepositorySystem getRepositorySystem() {
        this.checkClosed();
        if (this.repositorySystem == null) {
            this.repositorySystem = this.createRepositorySystem();
        }
        return this.repositorySystem;
    }

    protected RepositorySystem createRepositorySystem() {
        return new DefaultRepositorySystem(this.getVersionResolver(), this.getVersionRangeResolver(), this.getArtifactResolver(), this.getMetadataResolver(), this.getArtifactDescriptorReader(), this.getDependencyCollector(), this.getInstaller(), this.getDeployer(), this.getLocalRepositoryProvider(), this.getSyncContextFactory(), this.getRemoteRepositoryManager(), this.getRepositorySystemLifecycle());
    }

    @Override
    public RepositorySystem get() {
        return this.getRepositorySystem();
    }
}

