/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.HttpConstants;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporter;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterException;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transport.apache.ConnMgrConfig;
import org.eclipse.aether.transport.apache.DeferredCredentialsProvider;
import org.eclipse.aether.transport.apache.DemuxCredentialsProvider;
import org.eclipse.aether.transport.apache.HttpMkCol;
import org.eclipse.aether.transport.apache.LocalState;
import org.eclipse.aether.transport.apache.SharingHttpContext;
import org.eclipse.aether.transport.apache.UriUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApacheTransporter
extends AbstractTransporter
implements HttpTransporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheTransporter.class);
    private final ChecksumExtractor checksumExtractor;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final URI baseUri;
    private final HttpHost server;
    private final HttpHost proxy;
    private final CloseableHttpClient client;
    private final Map<?, ?> headers;
    private final LocalState state;
    private final boolean preemptiveAuth;
    private final boolean preemptivePutAuth;
    private final boolean supportWebDav;

    ApacheTransporter(RemoteRepository repository, RepositorySystemSession session, ChecksumExtractor checksumExtractor) throws NoTransporterException {
        boolean reuseConnections;
        String expectContinue;
        DefaultHttpRequestRetryHandler retryHandler;
        if (!"http".equalsIgnoreCase(repository.getProtocol()) && !"https".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.checksumExtractor = checksumExtractor;
        try {
            this.baseUri = new URI(repository.getUrl()).parseServerAuthority();
            if (this.baseUri.isOpaque()) {
                throw new URISyntaxException(repository.getUrl(), "URL must not be opaque");
            }
            this.server = URIUtils.extractHost(this.baseUri);
            if (this.server == null) {
                throw new URISyntaxException(repository.getUrl(), "URL lacks host name");
            }
        }
        catch (URISyntaxException e) {
            throw new NoTransporterException(repository, e.getMessage(), e);
        }
        this.proxy = ApacheTransporter.toHost(repository.getProxy());
        this.repoAuthContext = AuthenticationContext.forRepository(session, repository);
        this.proxyAuthContext = AuthenticationContext.forProxy(session, repository);
        String httpsSecurityMode = ConfigUtils.getString(session, "default", "aether.transport.https.securityMode." + repository.getId(), "aether.transport.https.securityMode");
        int connectionMaxTtlSeconds = ConfigUtils.getInteger(session, 300, "aether.transport.http.connectionMaxTtl." + repository.getId(), "aether.transport.http.connectionMaxTtl");
        int maxConnectionsPerRoute = ConfigUtils.getInteger(session, 50, "aether.transport.http.maxConnectionsPerRoute." + repository.getId(), "aether.transport.http.maxConnectionsPerRoute");
        this.state = new LocalState(session, repository, new ConnMgrConfig(session, this.repoAuthContext, httpsSecurityMode, connectionMaxTtlSeconds, maxConnectionsPerRoute));
        this.headers = ConfigUtils.getMap(session, Collections.emptyMap(), "aether.transport.http.headers." + repository.getId(), "aether.transport.http.headers");
        this.preemptiveAuth = ConfigUtils.getBoolean(session, false, "aether.transport.http.preemptiveAuth." + repository.getId(), "aether.transport.http.preemptiveAuth");
        this.preemptivePutAuth = ConfigUtils.getBoolean(session, true, "aether.transport.http.preemptivePutAuth." + repository.getId(), "aether.transport.http.preemptivePutAuth");
        this.supportWebDav = ConfigUtils.getBoolean(session, false, "aether.transport.http.supportWebDav." + repository.getId(), "aether.transport.http.supportWebDav");
        String credentialEncoding = ConfigUtils.getString(session, "ISO-8859-1", "aether.transport.http.credentialEncoding." + repository.getId(), "aether.transport.http.credentialEncoding");
        int connectTimeout = ConfigUtils.getInteger(session, 10000, "aether.transport.http.connectTimeout." + repository.getId(), "aether.transport.http.connectTimeout");
        int requestTimeout = ConfigUtils.getInteger(session, 1800000, "aether.transport.http.requestTimeout." + repository.getId(), "aether.transport.http.requestTimeout");
        int retryCount = ConfigUtils.getInteger(session, 3, "aether.transport.http.retryHandler.count." + repository.getId(), "aether.transport.http.retryHandler.count");
        long retryInterval = ConfigUtils.getLong(session, 5000L, "aether.transport.http.retryHandler.interval." + repository.getId(), "aether.transport.http.retryHandler.interval");
        long retryIntervalMax = ConfigUtils.getLong(session, 300000L, "aether.transport.http.retryHandler.intervalMax." + repository.getId(), "aether.transport.http.retryHandler.intervalMax");
        String serviceUnavailableCodesString = ConfigUtils.getString(session, "429,503", "aether.transport.http.retryHandler.serviceUnavailable." + repository.getId(), "aether.transport.http.retryHandler.serviceUnavailable");
        String retryHandlerName = ConfigUtils.getString(session, "standard", "aether.transport.apache.retryHandler.name." + repository.getId(), "aether.transport.apache.retryHandler.name");
        boolean retryHandlerRequestSentEnabled = ConfigUtils.getBoolean(session, false, "aether.transport.apache.retryHandler.requestSentEnabled." + repository.getId(), "aether.transport.apache.retryHandler.requestSentEnabled");
        String userAgent = ConfigUtils.getString(session, "Aether", "aether.transport.http.userAgent");
        Charset credentialsCharset = Charset.forName(credentialEncoding);
        Registry<AuthSchemeProvider> authSchemeRegistry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory(credentialsCharset)).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory(credentialsCharset))).register("NTLM", (BasicSchemeFactory)((Object)new NTLMSchemeFactory())).register("Negotiate", (BasicSchemeFactory)((Object)new SPNegoSchemeFactory())).register("Kerberos", (BasicSchemeFactory)((Object)new KerberosSchemeFactory())).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(requestTimeout).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setLocalAddress(this.getHttpLocalAddress(session, repository)).setSocketTimeout(requestTimeout).build();
        if ("standard".equals(retryHandlerName)) {
            retryHandler = new StandardHttpRequestRetryHandler(retryCount, retryHandlerRequestSentEnabled);
        } else if ("default".equals(retryHandlerName)) {
            retryHandler = new DefaultHttpRequestRetryHandler(retryCount, retryHandlerRequestSentEnabled);
        } else {
            throw new IllegalArgumentException("Unsupported parameter aether.transport.apache.retryHandler.name value: " + retryHandlerName);
        }
        HashSet<Integer> serviceUnavailableCodes = new HashSet<Integer>();
        try {
            for (String code : ConfigUtils.parseCommaSeparatedUniqueNames(serviceUnavailableCodesString)) {
                serviceUnavailableCodes.add(Integer.parseInt(code));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal HTTP codes for aether.transport.http.retryHandler.serviceUnavailable (list of integers): " + serviceUnavailableCodesString);
        }
        ResolverServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new ResolverServiceUnavailableRetryStrategy(retryCount, retryInterval, retryIntervalMax, serviceUnavailableCodes);
        HttpClientBuilder builder = HttpClientBuilder.create().setUserAgent(userAgent).setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy).setRetryHandler(retryHandler).setDefaultAuthSchemeRegistry(authSchemeRegistry).setConnectionManager(this.state.getConnectionManager()).setConnectionManagerShared(true).setDefaultCredentialsProvider(ApacheTransporter.toCredentialsProvider(this.server, this.repoAuthContext, this.proxy, this.proxyAuthContext)).setProxy(this.proxy);
        boolean useSystemProperties = ConfigUtils.getBoolean(session, false, "aether.transport.apache.useSystemProperties." + repository.getId(), "aether.transport.apache.useSystemProperties");
        if (useSystemProperties) {
            LOGGER.warn("Transport used Apache HttpClient is instructed to use system properties: this may yield in unwanted side-effects!");
            LOGGER.warn("Please use documented means to configure resolver transport.");
            builder.useSystemProperties();
        }
        if ((expectContinue = ConfigUtils.getString(session, null, "aether.transport.http.expectContinue." + repository.getId(), "aether.transport.http.expectContinue")) != null) {
            this.state.setExpectContinue(Boolean.parseBoolean(expectContinue));
        }
        if (!(reuseConnections = ConfigUtils.getBoolean(session, true, "aether.transport.http.reuseConnections." + repository.getId(), "aether.transport.http.reuseConnections"))) {
            builder.setConnectionReuseStrategy(NoConnectionReuseStrategy.INSTANCE);
        }
        this.client = builder.build();
    }

    private InetAddress getHttpLocalAddress(RepositorySystemSession session, RemoteRepository repository) {
        String bindAddress = ConfigUtils.getString(session, null, "aether.transport.http.localAddress." + repository.getId(), "aether.transport.http.localAddress");
        if (bindAddress == null) {
            return null;
        }
        try {
            return InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Given bind address (" + bindAddress + ") cannot be resolved for remote repository " + repository, uhe);
        }
    }

    private static HttpHost toHost(Proxy proxy) {
        HttpHost host = null;
        if (proxy != null) {
            host = new HttpHost(proxy.getHost(), proxy.getPort());
        }
        return host;
    }

    private static CredentialsProvider toCredentialsProvider(HttpHost server, AuthenticationContext serverAuthCtx, HttpHost proxy, AuthenticationContext proxyAuthCtx) {
        CredentialsProvider provider = ApacheTransporter.toCredentialsProvider(server.getHostName(), -1, serverAuthCtx);
        if (proxy != null) {
            CredentialsProvider p = ApacheTransporter.toCredentialsProvider(proxy.getHostName(), proxy.getPort(), proxyAuthCtx);
            provider = new DemuxCredentialsProvider(provider, p, proxy);
        }
        return provider;
    }

    private static CredentialsProvider toCredentialsProvider(String host, int port, AuthenticationContext ctx) {
        DeferredCredentialsProvider provider = new DeferredCredentialsProvider();
        if (ctx != null) {
            AuthScope basicScope = new AuthScope(host, port);
            provider.setCredentials(basicScope, new DeferredCredentialsProvider.BasicFactory(ctx));
            AuthScope ntlmScope = new AuthScope(host, port, AuthScope.ANY_REALM, "ntlm");
            provider.setCredentials(ntlmScope, new DeferredCredentialsProvider.NtlmFactory(ctx));
        }
        return provider;
    }

    LocalState getState() {
        return this.state;
    }

    private URI resolve(TransportTask task) {
        return UriUtils.resolve(this.baseUri, task.getLocation());
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof HttpTransporterException && ((HttpTransporterException)error).getStatusCode() == 404) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implPeek(PeekTask task) throws Exception {
        HttpHead request = this.commonHeaders(new HttpHead(this.resolve(task)));
        try {
            this.execute(request, null);
        }
        catch (HttpResponseException e) {
            throw new HttpTransporterException(e.getStatusCode());
        }
    }

    @Override
    protected void implGet(GetTask task) throws Exception {
        boolean resume = true;
        EntityGetter getter = new EntityGetter(task);
        HttpGet request = this.commonHeaders(new HttpGet(this.resolve(task)));
        while (true) {
            try {
                if (resume) {
                    this.resume(request, task);
                }
                this.execute(request, getter);
            }
            catch (HttpResponseException e) {
                if (resume && e.getStatusCode() == 412 && request.containsHeader("Range")) {
                    request = this.commonHeaders(new HttpGet(this.resolve(task)));
                    resume = false;
                    continue;
                }
                throw new HttpTransporterException(e.getStatusCode());
            }
            break;
        }
    }

    @Override
    protected void implPut(PutTask task) throws Exception {
        PutTaskEntity entity = new PutTaskEntity(task);
        HttpPut request = this.commonHeaders(this.entity(new HttpPut(this.resolve(task)), entity));
        try {
            this.execute(request, null);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 417 && request.containsHeader("Expect")) {
                this.state.setExpectContinue(false);
                request = this.commonHeaders(this.entity(new HttpPut(request.getURI()), entity));
                this.execute(request, null);
                return;
            }
            throw new HttpTransporterException(e.getStatusCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpUriRequest request, EntityGetter getter) throws Exception {
        try {
            SharingHttpContext context = new SharingHttpContext(this.state);
            this.prepare(request, context);
            try (CloseableHttpResponse response = this.client.execute(this.server, (HttpRequest)request, (HttpContext)context);){
                try {
                    context.close();
                    this.handleStatus(response);
                    if (getter != null) {
                        getter.handle(response);
                    }
                }
                finally {
                    EntityUtils.consumeQuietly(response.getEntity());
                }
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof TransferCancelledException) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private void prepare(HttpUriRequest request, SharingHttpContext context) throws HttpTransporterException {
        boolean put = "PUT".equalsIgnoreCase(request.getMethod());
        if (this.preemptiveAuth || this.preemptivePutAuth && put) {
            context.getAuthCache().put(this.server, new BasicScheme());
        }
        if (this.supportWebDav) {
            if (this.state.getWebDav() == null && (put || this.isPayloadPresent(request))) {
                HttpOptions req = this.commonHeaders(new HttpOptions(request.getURI()));
                try (CloseableHttpResponse response = this.client.execute(this.server, (HttpRequest)req, (HttpContext)context);){
                    this.state.setWebDav(response.containsHeader("Dav"));
                    EntityUtils.consumeQuietly(response.getEntity());
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to prepare HTTP context", e);
                }
            }
            if (put && Boolean.TRUE.equals(this.state.getWebDav())) {
                this.mkdirs(request.getURI(), context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mkdirs(URI uri, SharingHttpContext context) throws HttpTransporterException {
        CloseableHttpResponse response;
        int index;
        List<URI> dirs = UriUtils.getDirectories(this.baseUri, uri);
        for (index = 0; index < dirs.size(); ++index) {
            try {
                response = this.client.execute(this.server, (HttpRequest)this.commonHeaders(new HttpMkCol(dirs.get(index))), (HttpContext)context);
                try {
                    try {
                        int status = response.getStatusLine().getStatusCode();
                        if (status < 300 || status == 405) break;
                        if (status == 409) continue;
                        this.handleStatus(response);
                        continue;
                    }
                    finally {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug("Failed to create parent directory {}", (Object)dirs.get(index), (Object)e);
                return;
            }
        }
        --index;
        while (index >= 0) {
            try {
                response = this.client.execute(this.server, (HttpRequest)this.commonHeaders(new HttpMkCol(dirs.get(index))), (HttpContext)context);
                try {
                    try {
                        this.handleStatus(response);
                    }
                    finally {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug("Failed to create parent directory {}", (Object)dirs.get(index), (Object)e);
                return;
            }
            --index;
        }
    }

    private <T extends HttpEntityEnclosingRequest> T entity(T request, HttpEntity entity) {
        request.setEntity(entity);
        return request;
    }

    private boolean isPayloadPresent(HttpUriRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)((Object)request)).getEntity();
            return entity != null && entity.getContentLength() != 0L;
        }
        return false;
    }

    private <T extends HttpUriRequest> T commonHeaders(T request) {
        request.setHeader("Cache-Control", "no-cache, no-store");
        request.setHeader("Pragma", "no-cache");
        if (this.state.isExpectContinue() && this.isPayloadPresent(request)) {
            request.setHeader("Expect", "100-continue");
        }
        for (Map.Entry<?, ?> entry : this.headers.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            if (entry.getValue() instanceof String) {
                request.setHeader(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            request.removeHeaders(entry.getKey().toString());
        }
        if (!this.state.isExpectContinue()) {
            request.removeHeaders("Expect");
        }
        return request;
    }

    private <T extends HttpUriRequest> void resume(T request, GetTask task) throws IOException {
        long resumeOffset = task.getResumeOffset();
        if (resumeOffset > 0L && task.getDataPath() != null) {
            long lastModified = Files.getLastModifiedTime(task.getDataPath(), new LinkOption[0]).toMillis();
            request.setHeader("Range", "bytes=" + resumeOffset + '-');
            request.setHeader("If-Unmodified-Since", DateUtils.formatDate(new Date(lastModified - 60000L)));
            request.setHeader("Accept-Encoding", "identity");
        }
    }

    private void handleStatus(CloseableHttpResponse response) throws HttpResponseException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 300) {
            throw new HttpResponseException(status, response.getStatusLine().getReasonPhrase() + " (" + status + ")");
        }
    }

    @Override
    protected void implClose() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        AuthenticationContext.close(this.repoAuthContext);
        AuthenticationContext.close(this.proxyAuthContext);
        this.state.close();
    }

    private static Function<String, String> headerGetter(CloseableHttpResponse closeableHttpResponse) {
        return s -> {
            Header header = closeableHttpResponse.getFirstHeader((String)s);
            return header != null ? header.getValue() : null;
        };
    }

    private static class ResolverServiceUnavailableRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private final int retryCount;
        private final long retryInterval;
        private final long retryIntervalMax;
        private final Set<Integer> serviceUnavailableHttpCodes;
        private static final ThreadLocal<Long> RETRY_INTERVAL_HOLDER = new ThreadLocal();

        private ResolverServiceUnavailableRetryStrategy(int retryCount, long retryInterval, long retryIntervalMax, Set<Integer> serviceUnavailableHttpCodes) {
            if (retryCount < 0) {
                throw new IllegalArgumentException("retryCount must be >= 0");
            }
            if (retryInterval < 0L) {
                throw new IllegalArgumentException("retryInterval must be >= 0");
            }
            if (retryIntervalMax < 0L) {
                throw new IllegalArgumentException("retryIntervalMax must be >= 0");
            }
            this.retryCount = retryCount;
            this.retryInterval = retryInterval;
            this.retryIntervalMax = retryIntervalMax;
            this.serviceUnavailableHttpCodes = Objects.requireNonNull(serviceUnavailableHttpCodes);
        }

        @Override
        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            Long retryInterval;
            boolean retry;
            boolean bl = retry = executionCount <= this.retryCount && this.serviceUnavailableHttpCodes.contains(response.getStatusLine().getStatusCode());
            if (retry && (retryInterval = this.retryInterval(response, executionCount, context)) != null) {
                RETRY_INTERVAL_HOLDER.set(retryInterval);
                return true;
            }
            RETRY_INTERVAL_HOLDER.remove();
            return false;
        }

        private Long retryInterval(HttpResponse httpResponse, int executionCount, HttpContext httpContext) {
            Long result = null;
            Header header = httpResponse.getFirstHeader("Retry-After");
            if (header != null && header.getValue() != null) {
                String headerValue = header.getValue();
                if (headerValue.contains(":")) {
                    Date when = DateUtils.parseDate(headerValue);
                    if (when != null) {
                        result = Math.max(when.getTime() - System.currentTimeMillis(), 0L);
                    }
                } else {
                    try {
                        result = Long.parseLong(headerValue) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) {
                result = (long)executionCount * this.retryInterval;
            }
            if (result > this.retryIntervalMax) {
                return null;
            }
            return result;
        }

        @Override
        public long getRetryInterval() {
            Long ri = RETRY_INTERVAL_HOLDER.get();
            if (ri == null) {
                return 0L;
            }
            RETRY_INTERVAL_HOLDER.remove();
            return ri;
        }
    }

    private class EntityGetter {
        private final GetTask task;

        EntityGetter(GetTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(CloseableHttpResponse response) throws IOException, TransferCancelledException {
            Date lastModified;
            Header lastModifiedHeader;
            String range;
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                entity = new ByteArrayEntity(new byte[0]);
            }
            long offset = 0L;
            long length = entity.getContentLength();
            Header rangeHeader = response.getFirstHeader("Content-Range");
            String string = range = rangeHeader != null ? rangeHeader.getValue() : null;
            if (range != null) {
                Matcher m = HttpConstants.CONTENT_RANGE_PATTERN.matcher(range);
                if (!m.matches()) {
                    throw new IOException("Invalid Content-Range header for partial download: " + range);
                }
                offset = Long.parseLong(m.group(1));
                length = Long.parseLong(m.group(2)) + 1L;
                if (offset < 0L || offset >= length || offset > 0L && offset != this.task.getResumeOffset()) {
                    throw new IOException("Invalid Content-Range header for partial download from offset " + this.task.getResumeOffset() + ": " + range);
                }
            }
            boolean resume = offset > 0L;
            Path dataFile = this.task.getDataPath();
            if (dataFile == null) {
                try (InputStream is = entity.getContent();){
                    ApacheTransporter.this.utilGet(this.task, is, true, length, resume);
                    this.extractChecksums(response);
                }
            }
            try (FileUtils.CollocatedTempFile tempFile = FileUtils.newTempFile(dataFile);){
                this.task.setDataPath(tempFile.getPath(), resume);
                if (resume && Files.isRegularFile(dataFile, new LinkOption[0])) {
                    try (InputStream inputStream = Files.newInputStream(dataFile, new OpenOption[0]);){
                        Files.copy(inputStream, tempFile.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                try (InputStream is = entity.getContent();){
                    ApacheTransporter.this.utilGet(this.task, is, true, length, resume);
                }
                tempFile.move();
            }
            finally {
                this.task.setDataPath(dataFile);
            }
            if (this.task.getDataPath() != null && (lastModifiedHeader = response.getFirstHeader("Last-Modified")) != null && (lastModified = DateUtils.parseDate(lastModifiedHeader.getValue())) != null) {
                Files.setLastModifiedTime(this.task.getDataPath(), FileTime.fromMillis(lastModified.getTime()));
            }
            this.extractChecksums(response);
        }

        private void extractChecksums(CloseableHttpResponse response) {
            Map<String, String> checksums = ApacheTransporter.this.checksumExtractor.extractChecksums(ApacheTransporter.headerGetter(response));
            if (checksums != null && !checksums.isEmpty()) {
                checksums.forEach(this.task::setChecksum);
            }
        }
    }

    private class PutTaskEntity
    extends AbstractHttpEntity {
        private final PutTask task;

        PutTaskEntity(PutTask task) {
            this.task = task;
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public boolean isStreaming() {
            return false;
        }

        @Override
        public long getContentLength() {
            return this.task.getDataLength();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.task.newInputStream();
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            try {
                ApacheTransporter.this.utilPut(this.task, os, false);
            }
            catch (TransferCancelledException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
    }
}

