/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.apache;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

final class DemuxCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider serverCredentialsProvider;
    private final CredentialsProvider proxyCredentialsProvider;
    private final HttpHost proxy;

    DemuxCredentialsProvider(CredentialsProvider serverCredentialsProvider, CredentialsProvider proxyCredentialsProvider, HttpHost proxy) {
        this.serverCredentialsProvider = serverCredentialsProvider;
        this.proxyCredentialsProvider = proxyCredentialsProvider;
        this.proxy = proxy;
    }

    private CredentialsProvider getDelegate(AuthScope authScope) {
        if (this.proxy.getPort() == authScope.getPort() && this.proxy.getHostName().equalsIgnoreCase(authScope.getHost())) {
            return this.proxyCredentialsProvider;
        }
        return this.serverCredentialsProvider;
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        return this.getDelegate(authScope).getCredentials(authScope);
    }

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.getDelegate(authScope).setCredentials(authScope, credentials);
    }

    @Override
    public void clear() {
        this.serverCredentialsProvider.clear();
        this.proxyCredentialsProvider.clear();
    }
}

