/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryUriUtils;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.file.ResourceNotFoundException;

final class FileTransporter
extends AbstractTransporter {
    private final Path basePath;

    FileTransporter(RemoteRepository repository) throws NoTransporterException {
        try {
            this.basePath = Paths.get(RepositoryUriUtils.toUri(repository.getUrl())).toAbsolutePath();
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e) {
            throw new NoTransporterException(repository, (Throwable)e);
        }
    }

    Path getBasePath() {
        return this.basePath;
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implPeek(PeekTask task) throws Exception {
        this.getPath(task, true);
    }

    @Override
    protected void implGet(GetTask task) throws Exception {
        Path path = this.getPath(task, true);
        this.utilGet(task, Files.newInputStream(path, new OpenOption[0]), true, Files.size(path), false);
    }

    @Override
    protected void implPut(PutTask task) throws Exception {
        Path path = this.getPath(task, false);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try {
            this.utilPut(task, Files.newOutputStream(path, new OpenOption[0]), true);
        }
        catch (Exception e) {
            Files.deleteIfExists(path);
            throw e;
        }
    }

    private Path getPath(TransportTask task, boolean required) throws Exception {
        String path = task.getLocation().getPath();
        if (path.contains("../")) {
            throw new IllegalArgumentException("illegal resource path: " + path);
        }
        Path file = this.basePath.resolve(path);
        if (required && !Files.isRegularFile(file, new LinkOption[0])) {
            throw new ResourceNotFoundException("Could not locate " + file);
        }
        return file;
    }

    @Override
    protected void implClose() {
    }
}

