/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.version;

import java.util.Iterator;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.version.Version;

public final class HighestVersionFilter
implements VersionFilter {
    private final int count;

    public HighestVersionFilter() {
        this.count = 1;
    }

    public HighestVersionFilter(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Count should be greater or equal to 1");
        }
        this.count = count;
    }

    @Override
    public void filterVersions(VersionFilter.VersionFilterContext context) {
        if (context.getCount() <= this.count) {
            return;
        }
        int stepOver = context.getCount() - this.count;
        Iterator<Version> it = context.iterator();
        while (it.hasNext()) {
            it.next();
            if (--stepOver < 0) continue;
            it.remove();
        }
    }

    @Override
    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

