/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.VersionSchemeSupport;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public final class GenericVersionScheme
extends VersionSchemeSupport {
    @Override
    public GenericVersion parseVersion(String version) throws InvalidVersionSpecificationException {
        return new GenericVersion(version);
    }

    public static void main(String ... args) {
        System.out.println("Display parameters as parsed by Maven Resolver 'generic' scheme (in canonical form and as a list of tokens) and comparison result:");
        if (args.length == 0) {
            return;
        }
        GenericVersion prev = null;
        int i = 1;
        for (String version : args) {
            GenericVersion c = new GenericVersion(version);
            if (prev != null) {
                int compare = prev.compareTo(c);
                System.out.println("   " + prev + ' ' + (compare == 0 ? "==" : (compare < 0 ? "<" : ">")) + ' ' + version);
            }
            System.out.println(i++ + ". " + version + " -> " + c.asString() + "; tokens: " + c.asItems());
            prev = c;
        }
    }
}

