"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _config = require("../routes/config");
var _redirect_to_home_if_unauthorized = require("../routes/components/redirect_to_home_if_unauthorized");
var _app_context = require("../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ai_assistant_management/selection/public/management_section/mount_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const mountManagementSection = async ({
  core,
  mountParams,
  kibanaBranch,
  buildFlavor,
  securityAIAssistantEnabled
}) => {
  const [coreStart, startDeps] = await core.getStartServices();
  const {
    element,
    history,
    setBreadcrumbs
  } = mountParams;
  const {
    theme$
  } = core.theme;
  coreStart.chrome.docTitle.change(_i18n.i18n.translate('aiAssistantManagementSelection.app.titleBar', {
    defaultMessage: 'AI Assistants'
  }));
  _reactDom.default.render((0, _public.wrapWithTheme)(/*#__PURE__*/_react.default.createElement(_redirect_to_home_if_unauthorized.RedirectToHomeIfUnauthorized, {
    coreStart: coreStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: {
      ...startDeps,
      capabilities: coreStart.application.capabilities,
      navigateToApp: coreStart.application.navigateToApp,
      setBreadcrumbs,
      kibanaBranch,
      buildFlavor,
      securityAIAssistantEnabled
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.aIAssistantManagementSelectionRouter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }))))), theme$), element);
  return () => {
    coreStart.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;