"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverview = ServiceOverview;
exports.chartHeight = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _annotations_context = require("../../../context/annotations/annotations_context");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _apm_overview = require("./apm_overview");
var _search_bar = require("../../shared/search_bar/search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The height a chart should be if it's next to a table with 5 rows and a title.
 * Add the height of the pagination row.
 */
const chartHeight = exports.chartHeight = 288;
function ServiceOverview() {
  var _useApmPluginContext$;
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const setScreenContext = (_useApmPluginContext$ = (0, _use_apm_plugin_context.useApmPluginContext)().observabilityAIAssistant) === null || _useApmPluginContext$ === void 0 ? void 0 : _useApmPluginContext$.service.setScreenContext;
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      screenDescription: `The user is looking at the service overview page for ${serviceName}.`,
      data: [{
        name: 'service_name',
        description: 'The name of the service',
        value: serviceName
      }]
    });
  }, [setScreenContext, serviceName]);
  const {
    query: {
      environment,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    showTransactionTypeSelector: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_overview.ApmOverview, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  })))));
}