"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentExplorerDocsLink = AgentExplorerDocsLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../../../common/agent_name");
var _i18n2 = require("../../../../../../common/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_explorer/agent_explorer_docs_link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AgentExplorerDocsLink({
  agentName,
  repositoryUrl
}) {
  if (!repositoryUrl) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n2.NOT_AVAILABLE_LABEL);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `agentExplorerDocsLink_${agentName}`,
    href: repositoryUrl,
    target: "_blank",
    external: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, (0, _agent_name.isOpenTelemetryAgentName)(agentName) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documentation",
    size: "m",
    title: _i18n.i18n.translate('xpack.apm.agentExplorer.docsLink.otel.logo', {
      defaultMessage: 'Opentelemetry logo'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "m",
    title: _i18n.i18n.translate('xpack.apm.agentExplorer.docsLink.elastic.logo', {
      defaultMessage: 'Elastic logo'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }), ' ', _i18n.i18n.translate('xpack.apm.agentExplorer.docsLink.message', {
    defaultMessage: 'Docs'
  }));
}