"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanFlyout = SpanFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _common = require("@kbn/observability-plugin/common");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eventStacktrace = require("@kbn/event-stacktrace");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _open_span_in_discover_link = require("../../../../../../shared/links/discover_links/open_span_in_discover_link");
var _use_fetcher = require("../../../../../../../hooks/use_fetcher");
var _span_metadata = require("../../../../../../shared/metadata_table/span_metadata");
var _span_links_tab_content = require("../../../../../../shared/span_links/span_links_tab_content");
var _summary = require("../../../../../../shared/summary");
var _composite_span_duration_summary_item = require("../../../../../../shared/summary/composite_span_duration_summary_item");
var _http_info_summary_item = require("../../../../../../shared/summary/http_info_summary_item");
var _sync_badge = require("../badge/sync_badge");
var _failure_badge = require("../failure_badge");
var _responsive_flyout = require("../responsive_flyout");
var _span_db = require("./span_db");
var _sticky_span_properties = require("./sticky_span_properties");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/span_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function formatType(type) {
  switch (type) {
    case 'db':
      return 'DB';
    case 'hard-navigation':
      return _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanType.navigationTimingLabel', {
        defaultMessage: 'Navigation timing'
      });
    default:
      return type;
  }
}
function formatSubtype(subtype) {
  switch (subtype) {
    case 'mysql':
      return 'MySQL';
    default:
      return subtype;
  }
}
function getSpanTypes(span) {
  const {
    type,
    subtype,
    action
  } = span.span;
  return {
    spanType: formatType(type),
    spanSubtype: formatSubtype(subtype),
    spanAction: action
  };
}
const ContainerWithMarginRight = _styled.default.div`
  /* add margin to all direct descendants */
  & > * {
    margin-right: ${({
  theme
}) => theme.euiTheme.size.xs};
  }
`;
const INITIAL_DATA = {
  span: undefined,
  parentTransaction: undefined
};
function SpanFlyout({
  spanId,
  parentTransactionId,
  traceId,
  totalDuration,
  onClose,
  spanLinksCount,
  flyoutDetailTab,
  start,
  end
}) {
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/traces/{traceId}/spans/{spanId}', {
      params: {
        path: {
          traceId,
          spanId
        },
        query: {
          parentTransactionId,
          start,
          end
        }
      }
    });
  }, [traceId, spanId, parentTransactionId, start, end]);
  const {
    span,
    parentTransaction
  } = data;
  const isLoading = (0, _use_fetcher.isPending)(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_responsive_flyout.ResponsiveFlyout, {
    onClose: onClose,
    size: "m",
    ownFocus: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanDetailsTitle', {
    defaultMessage: 'Span details'
  })))), span && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_open_span_in_discover_link.OpenSpanInDiscoverLink, {
    dataTestSubj: "spanFlyoutViewSpanInDiscoverLink",
    spanId: spanId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }))), (span === null || span === void 0 ? void 0 : span.span.composite) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "gear",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.compositeExampleWarning', {
    defaultMessage: 'This is a sample document for a group of consecutive, similar spans'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, span && /*#__PURE__*/_react.default.createElement(SpanFlyoutBody, {
    span: span,
    parentTransaction: parentTransaction,
    totalDuration: totalDuration,
    spanLinksCount: spanLinksCount,
    flyoutDetailTab: flyoutDetailTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  })))));
}
function SpanFlyoutBody({
  span,
  parentTransaction,
  totalDuration,
  spanLinksCount,
  flyoutDetailTab
}) {
  var _span$code, _parentTransaction$se, _span$http, _span$http$response, _span$span, _span$span$http, _span$span$http$respo, _span$url, _span$span2, _span$span2$http, _span$span2$http$url, _span$http2, _span$http2$request, _span$span3, _span$span3$http, _span$trace, _span$span4, _tabs$find, _span$event;
  const stackframes = span.span.stacktrace;
  const plaintextStacktrace = (_span$code = span.code) === null || _span$code === void 0 ? void 0 : _span$code.stacktrace;
  const codeLanguage = parentTransaction === null || parentTransaction === void 0 ? void 0 : (_parentTransaction$se = parentTransaction.service.language) === null || _parentTransaction$se === void 0 ? void 0 : _parentTransaction$se.name;
  const spanDb = span.span.db;
  const spanTypes = getSpanTypes(span);
  const spanHttpStatusCode = ((_span$http = span.http) === null || _span$http === void 0 ? void 0 : (_span$http$response = _span$http.response) === null || _span$http$response === void 0 ? void 0 : _span$http$response.status_code) || ((_span$span = span.span) === null || _span$span === void 0 ? void 0 : (_span$span$http = _span$span.http) === null || _span$span$http === void 0 ? void 0 : (_span$span$http$respo = _span$span$http.response) === null || _span$span$http$respo === void 0 ? void 0 : _span$span$http$respo.status_code);
  const spanHttpUrl = ((_span$url = span.url) === null || _span$url === void 0 ? void 0 : _span$url.original) || ((_span$span2 = span.span) === null || _span$span2 === void 0 ? void 0 : (_span$span2$http = _span$span2.http) === null || _span$span2$http === void 0 ? void 0 : (_span$span2$http$url = _span$span2$http.url) === null || _span$span2$http$url === void 0 ? void 0 : _span$span2$http$url.original);
  const spanHttpMethod = ((_span$http2 = span.http) === null || _span$http2 === void 0 ? void 0 : (_span$http2$request = _span$http2.request) === null || _span$http2$request === void 0 ? void 0 : _span$http2$request.method) || ((_span$span3 = span.span) === null || _span$span3 === void 0 ? void 0 : (_span$span3$http = _span$span3.http) === null || _span$span3$http === void 0 ? void 0 : _span$span3$http.method);
  const spanLinksTabContent = (0, _span_links_tab_content.getSpanLinksTabContent)({
    spanLinksCount,
    traceId: (_span$trace = span.trace) === null || _span$trace === void 0 ? void 0 : _span$trace.id,
    spanId: (_span$span4 = span.span) === null || _span$span4 === void 0 ? void 0 : _span$span4.id,
    processorEvent: _common.ProcessorEvent.span
  });
  const tabs = [{
    id: 'metadata',
    name: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_span_metadata.SpanMetadata, {
      span: span,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 11
      }
    }))
  }, ...(!(0, _lodash.isEmpty)(stackframes) || !(0, _lodash.isEmpty)(plaintextStacktrace) ? [{
    id: 'stack-trace',
    'data-test-subj': 'spanStacktraceTab',
    name: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.stackTraceTabLabel', {
      defaultMessage: 'Stack Trace'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 17
      }
    }), stackframes ? /*#__PURE__*/_react.default.createElement(_eventStacktrace.Stacktrace, {
      stackframes: stackframes,
      codeLanguage: codeLanguage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(_eventStacktrace.PlaintextStacktrace, {
      stacktrace: plaintextStacktrace,
      codeLanguage: codeLanguage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 19
      }
    }))
  }] : []), ...(spanLinksTabContent ? [spanLinksTabContent] : [])];
  const initialTab = (_tabs$find = tabs.find(({
    id
  }) => id === flyoutDetailTab)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sticky_span_properties.StickySpanProperties, {
    span: span,
    transaction: parentTransaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_summary.Summary, {
    items: [/*#__PURE__*/_react.default.createElement(_apmUiShared.Timestamp, {
      timestamp: span.timestamp.us / 1000,
      renderMode: "tooltip",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_apmUiShared.Duration, {
      duration: span.span.duration.us,
      parent: {
        duration: totalDuration,
        type: 'transaction',
        loading: false
      },
      showTooltip: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 13
      }
    }), span.span.composite && /*#__PURE__*/_react.default.createElement(_composite_span_duration_summary_item.CompositeSpanDurationSummaryItem, {
      count: span.span.composite.count,
      durationSum: span.span.composite.sum.us,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(ContainerWithMarginRight, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 11
      }
    }, spanHttpUrl && /*#__PURE__*/_react.default.createElement(_http_info_summary_item.HttpInfoSummaryItem, {
      method: spanHttpMethod,
      url: spanHttpUrl,
      status: spanHttpStatusCode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanType', {
        defaultMessage: 'Type'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 15
      }
    }, spanTypes.spanType)), spanTypes.spanSubtype && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanSubtype', {
        defaultMessage: 'Subtype'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 17
      }
    }, spanTypes.spanSubtype)), spanTypes.spanAction && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.transactionDetails.spanFlyout.spanAction', {
        defaultMessage: 'Action'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 17
      }
    }, spanTypes.spanAction)), /*#__PURE__*/_react.default.createElement(_failure_badge.FailureBadge, {
      outcome: (_span$event = span.event) === null || _span$event === void 0 ? void 0 : _span$event.outcome,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_sync_badge.SyncBadge, {
      sync: span.span.sync,
      agentName: span.agent.name,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 13
      }
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_span_db.SpanDatabase, {
    spanDb: spanDb,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: initialTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 7
    }
  }));
}