"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWarning = TraceWarning;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _trace_waterfall_context = require("./trace_waterfall_context");
var _use_trace_waterfall = require("./use_trace_waterfall");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/trace_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FALLBACK_WARNING = _i18n.i18n.translate('xpack.apm.traceWaterfallContext.warningMessage.fallbackWarning', {
  defaultMessage: 'The trace document is incomplete and not all spans have arrived yet. Try refreshing the page or adjusting the time range.'
});
function TraceWarning({
  children
}) {
  const {
    traceState
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  switch (traceState) {
    case _use_trace_waterfall.TraceDataState.Partial:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "traceWarning",
        color: "warning",
        size: "s",
        title: FALLBACK_WARNING,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 11
        }
      }, children));
    case _use_trace_waterfall.TraceDataState.Empty:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "traceWarning",
        color: "warning",
        size: "s",
        title: FALLBACK_WARNING,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 9
        }
      });
    default:
      return children;
  }
}