"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContainerIdFromSignals = getContainerIdFromSignals;
var _queries = require("@kbn/observability-plugin/server/utils/queries");
var _moment = _interopRequireDefault(require("moment"));
var _apmTypes = require("@kbn/apm-types");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _maybe3 = require("../../../../common/utils/maybe");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getContainerIdFromSignals({
  query,
  esClient,
  logSourcesService,
  apmEventClient
}) {
  if (query['container.id']) {
    return query['container.id'];
  }
  if (!query['service.name']) {
    return;
  }
  const start = (0, _moment.default)(query.alert_started_at).subtract(30, 'minutes').valueOf();
  const end = (0, _moment.default)(query.alert_started_at).valueOf();
  const params = {
    _source: ['container.id'],
    terminate_after: 1,
    size: 1,
    track_total_hits: false,
    query: {
      bool: {
        filter: [{
          term: {
            'service.name': query['service.name']
          }
        }, {
          exists: {
            field: 'container.id'
          }
        }, ...(0, _queries.rangeQuery)(start, end)]
      }
    }
  };
  const containerId = await getContainerIdFromTraces({
    params,
    apmEventClient
  });
  if (containerId) {
    return containerId;
  }
  return getContainerIdFromLogs({
    params,
    esClient,
    logSourcesService
  });
}
async function getContainerIdFromLogs({
  params,
  esClient,
  logSourcesService
}) {
  var _maybe;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.CONTAINER_ID]);
  const index = await logSourcesService.getFlattenedLogSources();
  const res = await (0, _queries.typedSearch)(esClient, {
    index,
    ...params,
    fields: requiredFields
  });
  const event = (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe3.maybe)(res.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields, requiredFields);
  return event === null || event === void 0 ? void 0 : event.container.id;
}
async function getContainerIdFromTraces({
  params,
  apmEventClient
}) {
  var _maybe2;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.CONTAINER_ID]);
  const res = await apmEventClient.search('get_container_id_from_traces', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.TransactionEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    ...params,
    fields: requiredFields
  });
  const event = (0, _utils.unflattenKnownApmEventFields)((_maybe2 = (0, _maybe3.maybe)(res.hits.hits[0])) === null || _maybe2 === void 0 ? void 0 : _maybe2.fields, requiredFields);
  return event === null || event === void 0 ? void 0 : event.container.id;
}