"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsupportedLogFormatError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UnsupportedLogFormatError extends Error {
  constructor(unsupportedLogFormat) {
    super(unsupportedLogFormat.message);
    (0, _defineProperty2.default)(this, "errorCode", _constants.GenerationErrorCode.UNSUPPORTED_LOG_SAMPLES_FORMAT);
    (0, _defineProperty2.default)(this, "logFormat", void 0);
    if (unsupportedLogFormat.logFormat) {
      this.logFormat = unsupportedLogFormat.logFormat;
    }
  }
  sendResponse(res) {
    const responseBody = {
      message: this.message,
      attributes: {
        errorCode: this.errorCode
      }
    };
    if (this.logFormat) {
      responseBody.attributes.logFormat = this.logFormat;
    }
    return res.customError({
      statusCode: 501,
      body: responseBody
    });
  }
}
exports.UnsupportedLogFormatError = UnsupportedLogFormatError;