"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Datasource = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _expression_types = require("../../expression_types");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _elements = require("../../state/actions/elements");
var _datasource = require("./datasource");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/datasource/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatasourceComponent = props => {
  const {
    args,
    datasource
  } = props;
  const [stateArgs, updateArgs] = (0, _react.useState)(args);
  const [selecting, setSelecting] = (0, _react.useState)(false);
  const [previewing, setPreviewing] = (0, _react.useState)(false);
  const [isInvalid, setInvalid] = (0, _react.useState)(false);
  const [stateDatasource, selectDatasource] = (0, _react.useState)(datasource);
  const resetArgs = (0, _react.useCallback)(() => {
    updateArgs(args);
  }, [updateArgs, args]);
  return /*#__PURE__*/_react.default.createElement(_datasource.Datasource, (0, _extends2.default)({}, props, {
    stateArgs: stateArgs,
    updateArgs: updateArgs,
    selecting: selecting,
    setSelecting: setSelecting,
    previewing: previewing,
    setPreviewing: setPreviewing,
    isInvalid: isInvalid,
    setInvalid: setInvalid,
    stateDatasource: stateDatasource,
    selectDatasource: selectDatasource,
    resetArgs: resetArgs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }));
};
const mapStateToProps = state => ({
  element: (0, _workpad.getSelectedElement)(state),
  pageId: (0, _workpad.getSelectedPage)(state),
  functionDefinitions: (0, _app.getServerFunctions)(state)
});
const mapDispatchToProps = dispatch => ({
  dispatchAstAtIndex: ({
    index,
    element,
    pageId
  }) => ast => {
    dispatch((0, _elements.flushContext)(element.id));
    dispatch((0, _elements.setAstAtIndex)(index, ast, element, pageId));
  }
});
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    element,
    pageId,
    functionDefinitions
  } = stateProps;
  const {
    dispatchAstAtIndex
  } = dispatchProps;
  const getDataTableFunctionsByName = name => functionDefinitions.find(fn => fn.name === name && fn.type === 'datatable');

  // find the matching datasource from the expression AST
  const datasourceAst = (0, _lodash.get)(element, 'ast.chain', []).map((astDef, i) => {
    // if it's not a function, it's can't be a datasource
    if (astDef.type !== 'function') {
      return;
    }
    const args = astDef.arguments;

    // if there's no matching datasource in the registry, we're done
    const datasource = _expression_types.datasourceRegistry.get(astDef.function);
    if (!datasource) {
      return;
    }
    const datasourceDef = getDataTableFunctionsByName(datasource.name);

    // keep track of the ast, the ast index2, and the datasource
    return {
      datasource,
      datasourceDef,
      args,
      expressionIndex: i
    };
  }).filter(Boolean)[0];
  return {
    ...ownProps,
    ...stateProps,
    ...dispatchProps,
    ...datasourceAst,
    datasources: _expression_types.datasourceRegistry.toArray(),
    setDatasourceAst: dispatchAstAtIndex({
      pageId,
      element,
      index: datasourceAst && datasourceAst.expressionIndex
    })
  };
};
const Datasource = exports.Datasource = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(DatasourceComponent);
Datasource.propTypes = {
  done: _propTypes.PropTypes.func
};