"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Severity = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
var _domain = require("../../../common/types/domain");
var _selector = require("../severity/selector");
var _translations = require("../severity/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/case_form_fields/severity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SeverityComponent = ({
  isLoading
}) => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: 'severity',
  componentProps: {
    isLoading
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 3
  }
}, field => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const onChange = newSeverity => {
    field.setValue(newSeverity);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "caseSeverity",
    fullWidth: true,
    label: _translations.SEVERITY_TITLE,
    error: errorMessage,
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_selector.SeveritySelector, {
    isLoading: isLoading,
    isDisabled: isLoading,
    selectedSeverity: (0, _lodash.isEmpty)(field.value) ? _domain.CaseSeverity.LOW : field.value,
    onSeverityChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }));
});
SeverityComponent.displayName = 'SeverityComponent';
const Severity = exports.Severity = /*#__PURE__*/(0, _react.memo)(SeverityComponent);