"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  CaseCallOut: true
};
exports.CaseCallOut = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _callout = require("./callout");
var _helpers = require("./helpers");
Object.keys(_helpers).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _helpers[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _helpers[key];
    }
  });
});
var _navigation = require("../../../common/navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/use_push_to_service/callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseCallOutComponent = ({
  hasConnectors,
  hasLicenseError,
  onEditClick,
  messages = []
}) => {
  const {
    navigateToConfigureCases
  } = (0, _navigation.useConfigureCasesNavigation)();
  const handleCallOut = (0, _react.useCallback)(e => {
    e.preventDefault();
    // if theres connectors open dropdown editor
    // if no connectors, redirect to create case page
    if (hasConnectors) {
      onEditClick();
    } else {
      navigateToConfigureCases();
    }
  }, [hasConnectors, onEditClick, navigateToConfigureCases]);
  const groupedByTypeErrorMessages = (0, _react.useMemo)(() => messages.reduce((acc, currentMessage) => {
    var _acc$type$messagesId, _acc$type, _acc$type$messages, _acc$type2;
    const type = currentMessage.errorType == null ? 'primary' : currentMessage.errorType;
    return {
      ...acc,
      [type]: {
        messagesId: [...((_acc$type$messagesId = (_acc$type = acc[type]) === null || _acc$type === void 0 ? void 0 : _acc$type.messagesId) !== null && _acc$type$messagesId !== void 0 ? _acc$type$messagesId : []), currentMessage.id],
        messages: [...((_acc$type$messages = (_acc$type2 = acc[type]) === null || _acc$type2 === void 0 ? void 0 : _acc$type2.messages) !== null && _acc$type$messages !== void 0 ? _acc$type$messages : []), currentMessage]
      }
    };
  }, {}), [messages]);
  const groupedByTypeErrorMessagesKeys = Object.keys(groupedByTypeErrorMessages);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupedByTypeErrorMessagesKeys.map((type, index) => {
    const id = (0, _helpers.createCalloutId)(groupedByTypeErrorMessages[type].messagesId);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_callout.CallOut, {
      handleButtonClick: handleCallOut,
      id: id,
      messages: groupedByTypeErrorMessages[type].messages,
      type: type,
      hasLicenseError: hasLicenseError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }), index !== groupedByTypeErrorMessagesKeys.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 68
      }
    }) : null);
  }));
};
CaseCallOutComponent.displayName = 'CaseCallOut';
const CaseCallOut = exports.CaseCallOut = /*#__PURE__*/(0, _react.memo)(CaseCallOutComponent);