"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspGetRulesStates = exports.CSP_RULES_STATES_QUERY_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CSP_RULES_STATES_QUERY_KEY = exports.CSP_RULES_STATES_QUERY_KEY = ['csp_rules_states_v1'];
const useCspGetRulesStates = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(CSP_RULES_STATES_QUERY_KEY, () => http.get(_cloudSecurityPostureCommon.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH, {
    version: '1'
  }), {
    keepPreviousData: true
  });
};
exports.useCspGetRulesStates = useCspGetRulesStates;