"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSyncRulesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _advanced_sync_rules = require("./advanced_sync_rules");
var _edit_sync_rules_tab = require("./edit_sync_rules_tab");
var _editable_basic_rules_table = require("./editable_basic_rules_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/sync_rules/edit_sync_rules_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var FilteringTabs = /*#__PURE__*/function (FilteringTabs) {
  FilteringTabs["BASIC"] = "basic";
  FilteringTabs["ADVANCED"] = "advanced";
  return FilteringTabs;
}(FilteringTabs || {});
const EditSyncRulesFlyout = ({
  errors,
  hasAdvancedFilteringFeature,
  hasBasicFilteringFeature,
  revertLocalFilteringRules,
  revertLocalAdvancedFiltering,
  setIsEditing
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const tabs = [...(hasBasicFilteringFeature ? [{
    content: /*#__PURE__*/_react.default.createElement(_edit_sync_rules_tab.EditSyncRulesTab, {
      revertAction: revertLocalFilteringRules,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_editable_basic_rules_table.SyncRulesTable, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 17
      }
    })),
    id: FilteringTabs.BASIC,
    name: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.basicTabTitle', {
      defaultMessage: 'Basic rules'
    })
  }] : []), ...(hasAdvancedFilteringFeature ? [{
    content: /*#__PURE__*/_react.default.createElement(_edit_sync_rules_tab.EditSyncRulesTab, {
      revertAction: revertLocalAdvancedFiltering,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_advanced_sync_rules.AdvancedSyncRules, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 17
      }
    })),
    id: FilteringTabs.ADVANCED,
    name: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedTabTitle', {
      defaultMessage: 'Advanced rules'
    })
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: () => setIsEditing(false),
    "aria-labelledby": flyoutTitleId,
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.flyout.title', {
    defaultMessage: 'Draft rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.flyout.description', {
    defaultMessage: 'Plan and edit rules here before applying them to the next sync.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), !!(errors !== null && errors !== void 0 && errors.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, errors.map((error, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    id: `${index}`,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.flyout.errorTitle', {
      defaultMessage: 'Sync {idsLength, plural, one {rule} other {rules}} {ids} {idsLength, plural, one {is} other {are}} invalid.',
      values: {
        ids: error.ids.join(', '),
        idsLength: error.ids.length
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error.messages.map(message => /*#__PURE__*/_react.default.createElement("p", {
    id: message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 23
    }
  }, message)))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  })));
};
exports.EditSyncRulesFlyout = EditSyncRulesFlyout;