"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpRateLimiterService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _coreMetricsServerInternal = require("@kbn/core-metrics-server-internal");
var _coreStatusCommon = require("@kbn/core-status-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RATE_LIMITER_POLICY = 'elu';

/** @internal */

/** @internal */

/** @internal */

/** @internal */
class HttpRateLimiterService {
  constructor() {
    (0, _defineProperty2.default)(this, "status$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "state$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "ready$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "stopped$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "handler", (request, response, toolkit) => {
      const state = this.state$.getValue();
      if (request.route.options.excludeFromRateLimiter || !(state !== null && state !== void 0 && state.overloaded)) {
        return toolkit.next();
      }
      const timeout = state.retryAfter ? Math.max(Math.ceil((state.retryAfter - Date.now()) / 1000), 0) : 0;
      return response.customError({
        statusCode: 429,
        body: 'Server is overloaded',
        headers: {
          'Retry-After': `${timeout}`,
          RateLimit: `"${RATE_LIMITER_POLICY}";r=0;t=${timeout}`
        }
      });
    });
  }
  watch(metrics$, {
    elu,
    term
  }) {
    const period = _coreMetricsServerInternal.EluTerm[(0, _lodash.capitalize)(term)];
    metrics$.pipe((0, _rxjs.skipUntil)(this.ready$), (0, _rxjs.takeUntil)(this.stopped$), (0, _rxjs.map)(({
      short,
      medium,
      long
    }) => short >= elu && (term === 'short' || medium >= elu) && (term !== 'long' || long >= elu)), (0, _rxjs.endWith)(false), (0, _rxjs.map)(overloaded => ({
      overloaded,
      timestamp: Date.now()
    })), (0, _rxjs.scan)((previous, current) => {
      if (!current.overloaded) {
        return current;
      }
      const interval = previous !== null && previous !== void 0 && previous.timestamp ? current.timestamp - previous.timestamp : 0;
      const retryAfter = previous !== null && previous !== void 0 && previous.retryAfter && previous.retryAfter - current.timestamp > interval ? previous.retryAfter : current.timestamp + period + interval;
      return {
        ...current,
        retryAfter
      };
    }, undefined), (0, _rxjs.filter)(Boolean), (0, _rxjs.distinctUntilChanged)((previous, current) => (0, _lodash.isEqual)((0, _lodash.omit)(previous, 'timestamp'), (0, _lodash.omit)(current, 'timestamp')))).subscribe(this.state$);
    this.state$.pipe((0, _rxjs.map)(state => !!(state !== null && state !== void 0 && state.overloaded)), (0, _rxjs.distinctUntilChanged)(), (0, _rxjs.map)(overloaded => overloaded ? {
      level: _coreStatusCommon.ServiceStatusLevels.degraded,
      summary: 'http server is rate-limited due to high load'
    } : {
      level: _coreStatusCommon.ServiceStatusLevels.available,
      summary: 'http server is available'
    })).subscribe(this.status$);
  }
  setup({
    http,
    metrics
  }) {
    if (http.rateLimiter.enabled) {
      this.watch(metrics.getEluMetrics$(), http.rateLimiter);
      http.registerOnPreAuth(this.handler);
    }
    return {
      status$: this.status$
    };
  }
  start() {
    this.ready$.next(true);
    this.ready$.complete();
  }
  stop() {
    this.stopped$.next(true);
    this.stopped$.complete();
  }
}
exports.HttpRateLimiterService = HttpRateLimiterService;