"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRefineOrEndEdge = void 0;
var _get_max_hallucination_failures_reached = require("../../helpers/get_max_hallucination_failures_reached");
var _get_max_retries_reached = require("../../helpers/get_max_retries_reached");
var _get_refine_or_end_decision = require("./helpers/get_refine_or_end_decision");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRefineOrEndEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---REFINE OR END---');
    const {
      insights,
      generationAttempts,
      hallucinationFailures,
      maxGenerationAttempts,
      maxHallucinationFailures
    } = state;
    const hasFinalResults = insights !== null;
    const maxRetriesReached = (0, _get_max_retries_reached.getMaxRetriesReached)({
      generationAttempts,
      maxGenerationAttempts
    });
    const maxHallucinationFailuresReached = (0, _get_max_hallucination_failures_reached.getMaxHallucinationFailuresReached)({
      hallucinationFailures,
      maxHallucinationFailures
    });
    const decision = (0, _get_refine_or_end_decision.getRefineOrEndDecision)({
      hasFinalResults,
      maxHallucinationFailuresReached,
      maxRetriesReached
    });
    logger === null || logger === void 0 ? void 0 : logger.debug(() => {
      var _insights$length;
      return `refineOrEndEdge evaluated the following (derived) state:\n${JSON.stringify({
        insights: (_insights$length = insights === null || insights === void 0 ? void 0 : insights.length) !== null && _insights$length !== void 0 ? _insights$length : 0,
        generationAttempts,
        hallucinationFailures,
        hasFinalResults,
        maxHallucinationFailuresReached,
        maxRetriesReached
      }, null, 2)}
        \n---REFINE OR END: ${decision}---`;
    });
    return decision;
  };
  return edge;
};
exports.getRefineOrEndEdge = getRefineOrEndEdge;