"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeSerializer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../helpers");
var _components = require("../../../components");
var _use_form = require("../../hooks/use_form");
var _form = require("../form");
var _use_field = require("../use_field");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/form_de_serializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const deserializer = formDefault => {
  try {
    const url = new URL(formDefault.endPoint);
    const {
      protocol,
      hostname,
      pathname,
      port
    } = url;
    return {
      protocol,
      hostname,
      pathname,
      port: parseInt(port, 10)
    };
  } catch (e) {
    // Invalid URL
    return {
      protocol: '',
      hostname: '',
      pathname: ''
    };
  }
};
const serializer = ({
  protocol,
  hostname,
  port,
  pathname
}) => ({
  endPoint: `${protocol}//${hostname}:${port}${pathname === '/' ? '' : pathname}`
});
const FormWithDeSerializer = ({
  endPoint,
  ...args
}) => {
  const {
    form
  } = (0, _use_form.useForm)({
    serializer,
    deserializer,
    defaultValue: {
      endPoint
    }
  });
  return /*#__PURE__*/_react.default.createElement(_form.Form, (0, _extends2.default)({
    form: form
  }, args, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "protocol",
    component: _components.TextField,
    config: {
      label: 'Protocol'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "hostname",
    component: _components.TextField,
    config: {
      label: 'Host'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "port",
    component: _components.NumericField,
    config: {
      label: 'Port',
      formatters: [_helpers.fieldFormatters.toInt]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "pathname",
    component: _components.TextField,
    config: {
      label: 'Pathname'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => (0, _form_utils.submitForm)(form),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, "Send"));
};
const DeSerializer = args => {
  // We add a "key" to force a refresh of the form each time the end point arg changes
  return /*#__PURE__*/_react.default.createElement(FormWithDeSerializer, (0, _extends2.default)({
    key: args.endPoint
  }, args, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 10
    }
  }));
};
exports.DeSerializer = DeSerializer;
DeSerializer.storyName = '(De)serializer';
DeSerializer.argTypes = {
  endPoint: {
    name: 'formDefaultValue.endPoint',
    description: 'This endpoint comes from the backend and is passed to the form. We want to split the URL and the port to let the user modify them separately. For that we will deserialize the field into 2 form fields. When sending the form we will serialize back the 2 fields into one.',
    defaultValue: 'https://elastic.co:9200',
    control: {
      type: 'text'
    }
  }
};
DeSerializer.parameters = {
  docs: {
    source: {
      code: `
interface MyForm {
  endPoint: string;
}

interface MyFormInternal {
  protocol: string;
  hostname: string;
  port?: number;
  pathname: string;
}

const deserializer = (formDefault: MyForm): MyFormInternal => {
  try {
    const url = new URL(formDefault.endPoint);
    const { protocol, hostname, pathname, port } = url;

    return {
      protocol,
      hostname,
      pathname,
      port: parseInt(port, 10),
    };
  } catch (e) {
    // Invalid URL
    return {
      protocol: '',
      hostname: '',
      pathname: '',
    };
  }
};

const serializer = ({ protocol, hostname, port, pathname }: MyFormInternal): MyForm => ({
  endPoint: \`\${protocol}//\${hostname}:\${port}\${pathname === '/' ? '' : pathname}\`,
});

const MyFormComponent = ({ endPoint }) => {
  const { form } = useForm<MyForm, MyFormInternal>({
    serializer,
    deserializer,
    defaultValue: {
      endPoint,
    },
  });

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form} {...args}>
      <UseField<string> path="protocol" component={TextField} config={{ label: 'Protocol' }} />
      <UseField<string> path="hostname" component={TextField} config={{ label: 'Host' }} />
      <UseField<number>
        path="port"
        component={NumericField}
        config={{ label: 'Port', formatters: [fieldFormatters.toInt] }}
      />
      <UseField<string> path="pathname" component={TextField} config={{ label: 'Pathname' }} />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};