"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLYOUT_WIDTH_KEY = void 0;
exports.RowViewer = RowViewer;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/esql_datagrid/public/row_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FLYOUT_WIDTH_KEY = exports.FLYOUT_WIDTH_KEY = 'esqlTable:flyoutWidth';
/**
 * Flyout displaying an expanded ES|QL row
 */
function RowViewer({
  hit,
  hits,
  dataView,
  columns,
  columnsMeta,
  notifications,
  flyoutType = 'push',
  onClose,
  onRemoveColumn,
  onAddColumn,
  setExpandedDoc
}) {
  const services = (0, _react.useMemo)(() => ({
    toastNotifications: notifications === null || notifications === void 0 ? void 0 : notifications.toasts
  }), [notifications]);
  return /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerFlyout, {
    "data-test-subj": "esqlRowDetailsFlyout",
    flyoutWidthLocalStorageKey: FLYOUT_WIDTH_KEY,
    flyoutType: flyoutType,
    services: services,
    isEsqlQuery: true,
    hit: hit,
    hits: hits,
    dataView: dataView,
    columns: columns,
    columnsMeta: columnsMeta,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    onClose: onClose,
    setExpandedDoc: setExpandedDoc,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = RowViewer;