"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChooseColumnPopover = ChooseColumnPopover;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/esql/public/triggers/esql_controls/control_flyout/choose_column_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ChooseColumnPopover({
  columns,
  updateQuery
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [options, setOptions] = (0, _react.useState)(columns.map(column => ({
    label: column
  })));
  const onButtonClick = () => setIsPopoverOpen(status => !status);
  const closePopover = () => setIsPopoverOpen(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    css: (0, _react2.css)`
        vertical-align: top;
      `,
    onClick: onButtonClick,
    "data-test-subj": "chooseColumnBtn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('esql.flyout.chooseColumnBtn.label', {
    defaultMessage: 'here'
  }));
  const onColumnChange = (0, _react.useCallback)(newOptions => {
    setOptions(newOptions);
    const selectedColumn = newOptions.find(option => option.checked === 'on');
    if (selectedColumn) {
      updateQuery(selectedColumn.label);
    }
  }, [updateQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('esql.flyout.chooseColumnList.label', {
      defaultMessage: 'Select a column'
    }),
    searchable: true,
    searchProps: {
      'data-test-subj': 'selectableColumnSearch'
    },
    listProps: {
      'data-test-subj': 'selectableColumnList'
    },
    singleSelection: "always",
    options: options,
    onChange: onColumnChange,
    "data-test-subj": "selectableColumnContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)));
}