"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupPreview = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _lens_attributes = require("./lens_attributes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/event_annotation_listing/public/components/group_editor_flyout/group_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupPreview = ({
  group,
  dataViews,
  LensEmbeddableComponent,
  searchSessionId,
  refreshSearchSession,
  timePickerQuickRanges
}) => {
  const [chartTimeRange, setChartTimeRange] = (0, _react.useState)({
    from: 'now-15m',
    to: 'now'
  });
  const commonlyUsedRanges = (0, _react.useMemo)(() => {
    var _timePickerQuickRange;
    return (_timePickerQuickRange = timePickerQuickRanges === null || timePickerQuickRanges === void 0 ? void 0 : timePickerQuickRanges.map(({
      from,
      to,
      display
    }) => {
      return {
        start: from,
        end: to,
        label: display
      };
    })) !== null && _timePickerQuickRange !== void 0 ? _timePickerQuickRange : [];
  }, [timePickerQuickRanges]);
  const customQuickSelectRender = (0, _react.useCallback)(({
    quickSelect,
    commonlyUsedRanges: ranges,
    customQuickSelectPanels
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, customQuickSelectPanels, quickSelect, ranges), []);
  const currentDataView = (0, _react.useMemo)(() => dataViews.find(dataView => dataView.id === group.indexPatternId), [dataViews, group.indexPatternId]);
  const timeFieldNames = (0, _react.useMemo)(() => {
    var _currentDataView$fiel;
    return (_currentDataView$fiel = currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.fields.getByType('date').map(field => field.name)) !== null && _currentDataView$fiel !== void 0 ? _currentDataView$fiel : [];
  }, [currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.fields]);

  // We can assume that there is at least one time field because we don't allow annotation groups to be created without one
  const defaultTimeFieldName = (0, _react.useMemo)(() => {
    var _currentDataView$time;
    return (_currentDataView$time = currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName) !== null && _currentDataView$time !== void 0 ? _currentDataView$time : timeFieldNames[0];
  }, [currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName, timeFieldNames]);
  const [currentTimeFieldName, setCurrentTimeFieldName] = (0, _react.useState)(defaultTimeFieldName);
  const [lensAttributes, setLensAttributes] = (0, _react.useState)((0, _lens_attributes.getLensAttributes)(group, currentTimeFieldName));

  // we don't use currentDataView directly to hide/show the missing prompt because we want to delay
  // the embeddable render until the lensAttributes have been updated in useDebounce
  // in the case that the user selects a new data view
  const [showMissingDataViewPrompt, setShowMissingDataViewPrompt] = (0, _react.useState)(!currentDataView);
  (0, _react.useEffect)(() => {
    setCurrentTimeFieldName(defaultTimeFieldName);
  }, [defaultTimeFieldName]);
  (0, _useDebounce.default)(() => {
    setLensAttributes((0, _lens_attributes.getLensAttributes)(group, currentTimeFieldName));
    setShowMissingDataViewPrompt(!currentDataView);
  }, 250, [group, currentTimeFieldName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    css: (0, _react2.css)`
                  white-space: nowrap;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupPreview.preview",
    defaultMessage: "Preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              width: 336px;
              margin-top: -5px;
              margin-bottom: -5px;
            `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    onTimeChange: ({
      start: from,
      end: to
    }) => setChartTimeRange({
      from,
      to
    }),
    onRefresh: ({
      start: from,
      end: to
    }) => {
      setChartTimeRange({
        from,
        to
      });
      refreshSearchSession();
    },
    start: chartTimeRange.from,
    end: chartTimeRange.to,
    compressed: true,
    commonlyUsedRanges: commonlyUsedRanges,
    updateButtonProps: {
      iconOnly: true,
      fill: false
    },
    customQuickSelectRender: customQuickSelectRender,
    customQuickSelectPanels: [{
      title: _i18n.i18n.translate('eventAnnotationListing.timeField', {
        defaultMessage: 'Time field'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        "aria-label": _i18n.i18n.translate('eventAnnotationListing.timeField', {
          defaultMessage: 'Time field'
        }),
        options: timeFieldNames.map(name => ({
          text: name
        })),
        value: currentTimeFieldName,
        onChange: e => setCurrentTimeFieldName(e.target.value),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 21
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
          .euiFlyoutBody__overflowContent {
            height: 100%;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, !showMissingDataViewPrompt ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
              height: 100%;
            `,
    direction: "column",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(LensEmbeddableComponent, {
    css: (0, _react2.css)`
                  & > div {
                    height: 400px;
                    width: 100%;
                  }
                `,
    "data-test-subj": "chart",
    id: "annotation-library-preview",
    timeRange: chartTimeRange,
    attributes: lensAttributes,
    onBrushEnd: ({
      range
    }) => setChartTimeRange({
      from: new Date(range[0]).toISOString(),
      to: new Date(range[1]).toISOString()
    }),
    searchSessionId: searchSessionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
              height: 100%;
            `,
    direction: "column",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    "data-test-subj": "missingDataViewPrompt",
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotationListing.groupPreview.missingDataViewTitle",
      defaultMessage: "Select a valid data view",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 21
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotationListing.groupPreview.missingDataViewDescription",
      defaultMessage: "The previously selected data view no longer exists. Please select a valid data view in order to preview and use this annotation group.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  })))));
};
exports.GroupPreview = GroupPreview;