"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterValueButton = FilterValueButton;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _use_series_filters = require("../../hooks/use_series_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/filter_value_btn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FilterValueButton({
  isNestedOpen,
  setIsNestedOpen,
  value,
  field,
  negate,
  seriesId,
  series,
  nestedField,
  allSelectedValues
}) {
  var _dataViews$series$dat;
  const {
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const {
    setFilter,
    removeFilter
  } = (0, _use_series_filters.useSeriesFilters)({
    seriesId,
    series
  });
  const hasActiveFilters = (allSelectedValues !== null && allSelectedValues !== void 0 ? allSelectedValues : []).includes(value);
  const button = /*#__PURE__*/_react.default.createElement(FilterButton, {
    hasActiveFilters: hasActiveFilters,
    color: negate ? 'danger' : 'primary',
    onClick: () => {
      if (hasActiveFilters) {
        removeFilter({
          field,
          value,
          negate
        });
      } else {
        setFilter({
          field,
          value,
          negate
        });
      }
      if (!hasActiveFilters) {
        setIsNestedOpen({
          value,
          negate
        });
      } else {
        setIsNestedOpen({
          value: '',
          negate
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, negate ? _i18n.i18n.translate('xpack.exploratoryView.expView.filterValueButton.negate', {
    defaultMessage: 'Not {value}',
    values: {
      value
    }
  }) : value);
  const onNestedChange = valuesN => {
    (valuesN !== null && valuesN !== void 0 ? valuesN : []).forEach(valN => {
      setFilter({
        field: nestedField,
        value: valN
      });
    });
    setIsNestedOpen({
      value: '',
      negate
    });
  };
  const forceOpenNested = (isNestedOpen === null || isNestedOpen === void 0 ? void 0 : isNestedOpen.value) === value && isNestedOpen.negate === negate;
  const filters = (0, _react.useMemo)(() => {
    return [{
      term: {
        [field]: value
      }
    }];
  }, [field, value]);
  return nestedField && forceOpenNested ? /*#__PURE__*/_react.default.createElement(_public.FieldValueSuggestions, {
    button: button,
    label: _i18n.i18n.translate('xpack.exploratoryView.filterValueButton.fieldValueSuggestions.versionLabel', {
      defaultMessage: 'Version'
    }),
    sourceField: nestedField,
    onChange: onNestedChange,
    filters: filters,
    forceOpen: forceOpenNested,
    anchorPosition: "rightCenter",
    time: series.time,
    asCombobox: false,
    dataViewTitle: (_dataViews$series$dat = dataViews[series.dataType]) === null || _dataViews$series$dat === void 0 ? void 0 : _dataViews$series$dat.title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }) : button;
}
const FilterButton = (0, _styled.default)(_eui.EuiFilterButton)`
  background-color: rgba(
    ${props => {
  const color = props.hasActiveFilters ? props.color === 'danger' ? (0, _eui.hexToRgb)(props.theme.euiTheme.colors.danger) : (0, _eui.hexToRgb)(props.theme.euiTheme.colors.primary) : 'initial';
  return `${color[0]}, ${color[1]}, ${color[2]}, 0.1`;
}}
  );
`;