"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportTypesSelect = ReportTypesSelect;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_series_storage = require("../../hooks/use_series_storage");
var _exploratory_view_config = require("../../contexts/exploratory_view_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/report_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SELECT_REPORT_TYPE = 'SELECT_REPORT_TYPE';
const SELECT_REPORT = {
  reportType: SELECT_REPORT_TYPE,
  label: _i18n.i18n.translate('xpack.exploratoryView.expView.reportType.selectLabel', {
    defaultMessage: 'Select report type'
  })
};
function ReportTypesSelect({
  prepend
}) {
  const {
    setReportType,
    reportType: selectedReportType,
    allSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    reportTypes
  } = (0, _exploratory_view_config.useExploratoryView)();
  const onReportTypeChange = reportType => {
    setReportType(reportType);
  };
  const options = [SELECT_REPORT, ...reportTypes].filter(({
    reportType
  }) => selectedReportType ? reportType !== SELECT_REPORT_TYPE : true).map(({
    reportType,
    label
  }) => ({
    value: reportType,
    inputDisplay: reportType === SELECT_REPORT_TYPE ? label : /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 65
      }
    }, label),
    dropdownDisplay: label
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "aria-labelledby": "report-type-label",
    options: options,
    valueOfSelected: selectedReportType !== null && selectedReportType !== void 0 ? selectedReportType : SELECT_REPORT_TYPE,
    onChange: value => onReportTypeChange(value),
    style: {
      minWidth: 200
    },
    isInvalid: !selectedReportType && allSeries.length > 0,
    disabled: allSeries.length > 0,
    prepend: prepend,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
}