"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIcon = void 0;
var _chartIcons = require("@kbn/chart-icons");
var _types = require("../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getIcon = chart => ({
  [_types.ChartTypes.PIE]: _chartIcons.IconChartPie,
  [_types.ChartTypes.DONUT]: _chartIcons.IconChartDonut,
  [_types.ChartTypes.TREEMAP]: _chartIcons.IconChartTreemap,
  [_types.ChartTypes.MOSAIC]: _chartIcons.IconChartMosaic,
  [_types.ChartTypes.WAFFLE]: _chartIcons.IconChartWaffle
})[chart];
exports.getIcon = getIcon;