"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSchema = exports.getInnerType = exports.convertValue = exports.SettingsFieldWrapper = void 0;
var _zod = require("@kbn/zod");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _agent_policy_form = require("../../sections/agent_policy/components/agent_policy_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/form_settings/settings_field_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const convertValue = (value, type) => {
  if (type === _zod.ZodFirstPartyTypeKind.ZodNumber) {
    if (value === '') {
      return 0;
    }
    return parseInt(value, 10);
  }
  return value;
};
exports.convertValue = convertValue;
const validateSchema = (coercedSchema, newValue) => {
  const validationResults = coercedSchema.safeParse(newValue);
  if (!validationResults.success) {
    return validationResults.error.issues[0].message;
  }
};
exports.validateSchema = validateSchema;
const renderer = {
  renderCode: code => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 33
    }
  }, code)
};
const SettingsFieldWrapper = ({
  settingsConfig,
  typeName,
  renderItem,
  disabled
}) => {
  var _agentPolicyFormConte2, _agentPolicyFormConte3;
  const [error, setError] = (0, _react.useState)('');
  const agentPolicyFormContext = (0, _agent_policy_form.useAgentPolicyFormContext)();
  const fieldKey = `configuredSetting-${settingsConfig.name}`;
  const defaultValue = settingsConfig.schema instanceof _zod.z.ZodDefault ? settingsConfig.schema._def.defaultValue() : undefined;
  const coercedSchema = settingsConfig.schema;
  const handleChange = e => {
    var _agentPolicyFormConte;
    const value = typeName === _zod.ZodFirstPartyTypeKind.ZodBoolean ? e.target.checked : e.target.value;
    const newValue = convertValue(value, typeName);
    const validationError = validateSchema(coercedSchema, newValue);
    if (validationError) {
      setError(validationError);
      agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.updateAdvancedSettingsHasErrors(true);
    } else {
      setError('');
      agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.updateAdvancedSettingsHasErrors(false);
    }
    const newAdvancedSettings = {
      ...((_agentPolicyFormConte = agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.agentPolicy.advanced_settings) !== null && _agentPolicyFormConte !== void 0 ? _agentPolicyFormConte : {}),
      [settingsConfig.api_field.name]: newValue
    };
    agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.updateAgentPolicy({
      advanced_settings: newAdvancedSettings
    });
  };
  const fieldValue = (_agentPolicyFormConte2 = agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : (_agentPolicyFormConte3 = agentPolicyFormContext.agentPolicy.advanced_settings) === null || _agentPolicyFormConte3 === void 0 ? void 0 : _agentPolicyFormConte3[settingsConfig.api_field.name]) !== null && _agentPolicyFormConte2 !== void 0 ? _agentPolicyFormConte2 : defaultValue;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 14
      }
    }, settingsConfig.title),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, settingsConfig.description({
      renderer
    }), ' ', settingsConfig.learnMoreLink && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: settingsConfig.learnMoreLink,
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.configuredSettings.learnMoreLinkText",
      defaultMessage: "Learn more.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isDisabled: disabled,
    fullWidth: true,
    key: fieldKey,
    error: error,
    isInvalid: !!error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, renderItem({
    fieldValue,
    handleChange,
    isInvalid: !!error,
    fieldKey,
    coercedSchema
  })));
};
exports.SettingsFieldWrapper = SettingsFieldWrapper;
const getInnerType = schema => {
  if (schema._def.innerType) {
    return schema._def.innerType._def.typeName === 'ZodEffects' ? schema._def.innerType._def.schema._def.typeName : schema._def.innerType._def.typeName;
  }
  if (schema._def.typeName === 'ZodEffects') {
    return schema._def.schema._def.typeName;
  }
  return schema._def.typeName;
};
exports.getInnerType = getInnerType;