"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentSoftLimit = useAgentSoftLimit;
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchTotalOnlineAgents() {
  var _response$data$total, _response$data;
  const response = await (0, _hooks.sendGetAgents)({
    kuery: 'status:online',
    perPage: 0,
    showInactive: false
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  return (_response$data$total = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.total) !== null && _response$data$total !== void 0 ? _response$data$total : 0;
}
function useAgentSoftLimit() {
  var _config$internal;
  const config = (0, _hooks.useConfig)();
  const softLimit = (_config$internal = config.internal) === null || _config$internal === void 0 ? void 0 : _config$internal.activeAgentsSoftLimit;
  const {
    data: totalAgents
  } = (0, _reactQuery.useQuery)(['fetch-total-online-agents'], fetchTotalOnlineAgents, {
    enabled: softLimit !== undefined
  });
  return {
    shouldDisplayAgentSoftLimit: softLimit && totalAgents ? totalAgents > softLimit : false
  };
}