"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiRowInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/multi_row_input/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DraggableDiv = _styledComponents.default.div`
  margin: ${props => props.theme.eui.euiSizeS};
`;
function displayErrors(errors) {
  return errors !== null && errors !== void 0 && errors.length ? errors.map((error, errorIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    key: errorIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, error)) : null;
}
const SortableTextField = /*#__PURE__*/_react.default.memo(({
  id,
  index,
  multiline,
  value,
  onChange,
  onDelete,
  placeholder,
  autoFocus,
  errors,
  disabled
}) => {
  var _errors$length;
  const onDeleteHandler = (0, _react.useCallback)(() => {
    onDelete(index);
  }, [onDelete, index]);
  const isInvalid = ((_errors$length = errors === null || errors === void 0 ? void 0 : errors.length) !== null && _errors$length !== void 0 ? _errors$length : 0) > 0;
  const theme = (0, _styledComponents.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    index: index,
    draggableId: id,
    isDragDisabled: disabled,
    customDragHandle: true,
    style: {
      paddingLeft: 0,
      paddingRight: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, (provided, state) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    style: state.isDragging ? {
      background: theme.eui.euiPanelBackgroundColorModifiers.plain
    } : {},
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(DraggableDiv, (0, _extends2.default)({}, provided.dragHandleProps, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.settings.sortHandle', {
      defaultMessage: 'Sort host handle'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "text",
    type: "grab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, multiline ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: value,
    onChange: onChange,
    autoFocus: autoFocus,
    isInvalid: isInvalid,
    disabled: disabled,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: value,
    onChange: onChange,
    autoFocus: autoFocus,
    isInvalid: isInvalid,
    disabled: disabled,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  }), displayErrors(errors)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onDeleteHandler,
    iconType: "cross",
    disabled: disabled,
    "aria-label": _i18n.i18n.translate('xpack.fleet.multiRowInput.deleteButton', {
      defaultMessage: 'Delete row'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }))));
});
const NonSortableTextField = /*#__PURE__*/_react.default.memo(({
  index,
  deletable,
  multiline,
  value,
  onChange,
  onDelete,
  placeholder,
  autoFocus,
  errors,
  disabled
}) => {
  var _errors$length2;
  const onDeleteHandler = (0, _react.useCallback)(() => {
    onDelete(index);
  }, [onDelete, index]);
  const isInvalid = ((_errors$length2 = errors === null || errors === void 0 ? void 0 : errors.length) !== null && _errors$length2 !== void 0 ? _errors$length2 : 0) > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, multiline ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: value,
    onChange: onChange,
    autoFocus: autoFocus,
    isInvalid: isInvalid,
    disabled: disabled,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: value,
    onChange: onChange,
    autoFocus: autoFocus,
    isInvalid: isInvalid,
    disabled: disabled,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }), displayErrors(errors)), deletable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onDeleteHandler,
    iconType: "cross",
    disabled: disabled,
    "aria-label": _i18n.i18n.translate('xpack.fleet.multiRowInput.deleteButton', {
      defaultMessage: 'Delete row'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }))));
});
const MultiRowInput = ({
  id,
  value: valueFromProps,
  onChange,
  helpText,
  label,
  isInvalid,
  errors,
  disabled,
  placeholder,
  multiline = false,
  sortable = true,
  isUrl
}) => {
  const [autoFocus, setAutoFocus] = (0, _react.useState)(false);
  const value = (0, _react.useMemo)(() => {
    return valueFromProps.length ? valueFromProps : [''];
  }, [valueFromProps]);
  const rows = (0, _react.useMemo)(() => value.map((host, idx) => ({
    value: host,
    onChange: e => {
      const newValue = [...value];
      newValue[idx] = e.target.value;
      onChange(newValue);
    }
  })), [value, onChange]);
  const indexedErrors = (0, _react.useMemo)(() => {
    if (!errors) {
      return [];
    }
    return errors.reduce((acc, err) => {
      if (err.index === undefined) {
        return acc;
      }
      if (!acc[err.index]) {
        acc[err.index] = [];
      }
      acc[err.index].push(err.message);
      return acc;
    }, []);
  }, [errors]);
  const onDelete = (0, _react.useCallback)(idx => {
    indexedErrors.splice(idx, 1);
    onChange([...value.slice(0, idx), ...value.slice(idx + 1)]);
  }, [value, onChange, indexedErrors]);
  const addRowHandler = (0, _react.useCallback)(() => {
    setAutoFocus(true);
    onChange([...value, '']);
  }, [value, onChange]);
  const onDragEndHandler = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      const items = (0, _eui.euiDragDropReorder)(value, source.index, destination.index);
      const sourceErrors = indexedErrors[source.index];
      indexedErrors.splice(source.index, 1);
      indexedErrors.splice(destination.index, 0, sourceErrors);
      onChange(items);
    }
  }, [value, onChange, indexedErrors]);
  const globalErrors = (0, _react.useMemo)(() => {
    return errors && errors.filter(err => err.index === undefined).map(({
      message
    }) => message);
  }, [errors]);
  const isSortable = sortable && rows.length > 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: label,
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, helpText), helpText && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 22
    }
  }), isSortable ? /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEndHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: `${id}Droppable`,
    spacing: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 13
    }
  }, rows.map((row, idx) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(SortableTextField, {
    id: `${id}${idx}Draggable`,
    index: idx,
    onChange: row.onChange,
    onDelete: onDelete,
    value: row.value,
    autoFocus: autoFocus,
    errors: indexedErrors[idx],
    disabled: disabled,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 19
    }
  }))))) : rows.map((row, idx) => /*#__PURE__*/_react.default.createElement(NonSortableTextField, {
    key: idx,
    multiline: multiline,
    index: idx,
    onChange: row.onChange,
    onDelete: onDelete,
    value: row.value,
    autoFocus: autoFocus,
    errors: indexedErrors[idx],
    disabled: disabled,
    placeholder: placeholder,
    deletable: rows.length > 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 13
    }
  })), displayErrors(globalErrors), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "fleetServerHosts.multiRowInput.addRowButton",
    disabled: disabled,
    size: "xs",
    flush: "left",
    iconType: "plusInCircle",
    onClick: addRowHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 9
    }
  }, isUrl ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.multiRowInput.addAnotherUrl",
    defaultMessage: "Add another URL",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.multiRowInput.addRow",
    defaultMessage: "Add row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 13
    }
  }))));
};
exports.MultiRowInput = MultiRowInput;