"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownRenderers = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _overview = require("./overview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/overview/markdown_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** prevents links to the new pages from accessing `window.opener` */
const REL_NOOPENER = 'noopener';

/** prevents search engine manipulation by noting the linked document is not trusted or endorsed by us */
const REL_NOFOLLOW = 'nofollow';

/** prevents the browser from sending the current address as referrer via the Referer HTTP header */
const REL_NOREFERRER = 'noreferrer';

// Maps deprecated code block languages to supported ones in prism.js
const CODE_LANGUAGE_OVERRIDES = {
  $json: 'json',
  $yml: 'yml'
};
const StyledH3 = _styledComponents.default.h3`
  scroll-margin-top: 105px;
`;
const StyledH4 = _styledComponents.default.h4`
  scroll-margin-top: 105px;
`;
const StyledH5 = _styledComponents.default.h5`
  scroll-margin-top: 105px;
`;
const StyledH6 = _styledComponents.default.h5`
  scroll-margin-top: 105px;
`;

/*
  Refs passed from the parent component are needed to handle scrolling on selected header in the overviewPage
*/
const markdownRenderers = refs => {
  return {
    table: ({
      children
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 30
      }
    }, children),
    tr: ({
      children
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 27
      }
    }, children),
    th: ({
      children
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 27
      }
    }, children),
    td: ({
      children
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 27
      }
    }, children),
    // the headings used in markdown don't match our page so mapping them to the appropriate one
    h1: ({
      children,
      node
    }) => {
      var _children$, _node$position;
      const id = (0, _overview.getAnchorId)((_children$ = children[0]) === null || _children$ === void 0 ? void 0 : _children$.toString(), (_node$position = node.position) === null || _node$position === void 0 ? void 0 : _node$position.start.line);
      return /*#__PURE__*/_react.default.createElement(StyledH3, {
        ref: element => refs.current.set(`${id}`, element),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 14
        }
      }, children);
    },
    h2: ({
      children,
      node
    }) => {
      var _children$2, _node$position2;
      const id = (0, _overview.getAnchorId)((_children$2 = children[0]) === null || _children$2 === void 0 ? void 0 : _children$2.toString(), (_node$position2 = node.position) === null || _node$position2 === void 0 ? void 0 : _node$position2.start.line);
      return /*#__PURE__*/_react.default.createElement(StyledH4, {
        ref: element => refs.current.set(`${id}`, element),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 14
        }
      }, children);
    },
    h3: ({
      children,
      node
    }) => {
      var _children$3, _node$position3;
      const id = (0, _overview.getAnchorId)((_children$3 = children[0]) === null || _children$3 === void 0 ? void 0 : _children$3.toString(), (_node$position3 = node.position) === null || _node$position3 === void 0 ? void 0 : _node$position3.start.line);
      return /*#__PURE__*/_react.default.createElement(StyledH5, {
        ref: element => refs.current.set(`${id}`, element),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 14
        }
      }, children);
    },
    h4: ({
      children,
      node
    }) => {
      var _children$4, _node$position4;
      const id = (0, _overview.getAnchorId)((_children$4 = children[0]) === null || _children$4 === void 0 ? void 0 : _children$4.toString(), (_node$position4 = node.position) === null || _node$position4 === void 0 ? void 0 : _node$position4.start.line);
      return /*#__PURE__*/_react.default.createElement(StyledH6, {
        ref: element => refs.current.set(`${id}`, element),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 14
        }
      }, children);
    },
    h5: ({
      children
    }) => /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 27
      }
    }, children),
    h6: ({
      children
    }) => /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 27
      }
    }, children),
    a: ({
      children,
      href
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: href,
      target: "_blank",
      rel: `${REL_NOOPENER} ${REL_NOFOLLOW} ${REL_NOREFERRER}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    }, children),
    code: ({
      className,
      children,
      inline
    }) => {
      var _exec$, _exec;
      let parsedLang = (_exec$ = (_exec = /language-(\w+)/.exec(className || '')) === null || _exec === void 0 ? void 0 : _exec[1]) !== null && _exec$ !== void 0 ? _exec$ : '';

      // Some integrations export code block content that includes language tags that have since
      // been removed or deprecated in `prism.js`, the upstream depedency that handles syntax highlighting
      // in EuiCodeBlock components
      const languageOverride = parsedLang ? CODE_LANGUAGE_OVERRIDES[parsedLang] : undefined;
      if (languageOverride) {
        parsedLang = languageOverride;
      }
      if (inline) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 16
          }
        }, children);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: parsedLang,
        overflowHeight: 500,
        isCopyable: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 9
        }
      }, children);
    },
    img: props => {
      return /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
        style: {
          maxWidth: '100%'
        }
      }, props, {
        alt: props.alt,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 14
        }
      }));
    },
    details: ({
      children,
      node
    }) => {
      var _children$5, _node$position5;
      const [summaryNode, ...bodyNodes] = _react.default.Children.toArray(children).reduce(([summary, body], child) => {
        if (summary === null && /*#__PURE__*/_react.default.isValidElement(child) && child.type === 'summary') {
          return [child, body];
        }
        return [summary, [...body, child]];
      }, [null, []]);
      const summaryText = summaryNode ? _react.default.Children.toArray(summaryNode.props.children).join('') : '';
      const id = (0, _overview.getAnchorId)((_children$5 = children[0]) === null || _children$5 === void 0 ? void 0 : _children$5.toString(), (_node$position5 = node.position) === null || _node$position5 === void 0 ? void 0 : _node$position5.start.line);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: id,
        buttonContent: summaryText,
        initialIsOpen: false,
        "data-test-subj": "integrationsDocs.accordion",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }, bodyNodes), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 11
        }
      }));
    }
  };
};
exports.markdownRenderers = markdownRenderers;