"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getManifestDownloadLink = exports.KubernetesInstructions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _common = require("../../../common");
var _k8s = require("../../hooks/use_request/k8s");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/kubernetes_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getManifestDownloadLink = (fleetServerHost, enrollmentAPIKey) => {
  const searchParams = new URLSearchParams({
    apiVersion: _common.API_VERSIONS.public.v1,
    ...(fleetServerHost && {
      fleetServer: fleetServerHost
    }),
    ...(enrollmentAPIKey && {
      enrolToken: enrollmentAPIKey
    })
  });
  return `${_common.agentPolicyRouteService.getK8sFullDownloadPath()}?${searchParams.toString()}`;
};
exports.getManifestDownloadLink = getManifestDownloadLink;
const KubernetesInstructions = ({
  enrollmentAPIKey,
  onCopy,
  onDownload,
  fleetServerHost
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    notifications,
    docLinks
  } = core;
  const [yaml, setYaml] = (0, _react.useState)('');
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  const [downloadButtonClicked, setDownloadButtonClicked] = (0, _react.useState)(false);
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  const onDownloadButtonClick = downloadLink => {
    setDownloadButtonClicked(true);
    if (onDownload) onDownload();
    window.location.href = downloadLink;
  };
  (0, _react.useEffect)(() => {
    async function fetchK8sManifest() {
      try {
        const query = {
          enrolToken: enrollmentAPIKey,
          ...(fleetServerHost && {
            fleetServer: fleetServerHost
          })
        };
        const res = await (0, _k8s.sendGetK8sManifest)(query);
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching agent manifest');
        }
        setYaml(res.data.item);
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.loadk8sManifestErrorTitle', {
            defaultMessage: 'Error while fetching agent manifest'
          })
        });
      }
    }
    fetchK8sManifest();
  }, [notifications.toasts, enrollmentAPIKey, fleetServerHost]);
  const downloadDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadDescriptionForK8s",
    defaultMessage: "Copy or download the Kubernetes manifest. Note that the following manifest contains resource limits that may not be appropriate for a production environment, review our guide on {scalingGuideLink} before deploying this manifest.",
    values: {
      scalingGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.scalingKubernetesResourcesAndLimits,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleet.agentEnrollment.k8ScalingGuideLinkText",
        defaultMessage: "Scaling Elastic Agent on Kubernetes",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  });
  const k8sCopyYaml = /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: yaml,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onCopyButtonClick(copy),
    iconType: "copyClipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyPolicyButtonClicked",
    defaultMessage: "Copied",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyPolicyButton",
    defaultMessage: "Copy to clipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  })));
  const downloadLink = core.http.basePath.prepend(getManifestDownloadLink(fleetServerHost, enrollmentAPIKey));
  const k8sDownloadYaml = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    target: "_blank",
    iconSide: "right",
    iconType: "popout",
    onClick: () => onDownloadButtonClick(downloadLink),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, downloadButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadManifestButtonk8sClicked",
    defaultMessage: "Downloaded",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.downloadManifestButtonk8s",
    defaultMessage: "Download manifest",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })));
  const k8sYaml = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    style: {
      maxHeight: 300
    },
    fontSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, yaml);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, downloadDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sYaml), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCopyYaml)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sDownloadYaml))));
};
exports.KubernetesInstructions = KubernetesInstructions;