"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPicker = FieldPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _react2 = require("@emotion/react");
var _styles = require("../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/graph/public/components/field_manager/field_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldPicker({
  fieldMap,
  selectField,
  deselectField,
  open,
  setOpen
}) {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const allFields = Object.values(fieldMap);
  const hasFields = allFields.length > 0;
  const [fieldOptions, setFieldOptions] = (0, _react.useState)(toOptions(allFields));
  (0, _react.useEffect)(() => {
    if (!open) {
      // only update the field options if the popover is not open currently.
      // This is necessary because EuiSelectable assumes options don't change
      // on their own.
      setFieldOptions(toOptions(Object.values(fieldMap)));
    }
  }, [fieldMap, open]);
  const badgeDescription = _i18n.i18n.translate('xpack.graph.bar.pickFieldsLabel', {
    defaultMessage: 'Add fields'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "graphFieldPicker",
    anchorPosition: "downCenter",
    ownFocus: true,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "graph-add-field-button",
      color: "hollow",
      iconType: "plusInCircleFilled",
      "aria-disabled": !hasFields,
      onClick: () => {
        if (hasFields) {
          setOpen(!open);
        }
      },
      onClickAriaLabel: badgeDescription,
      css: [(0, _styles.gphFieldBadgeSizeStyles)(euiThemeContext), (0, _react2.css)({
        color: euiThemeContext.euiTheme.colors.primary,
        ...(!hasFields && {
          color: euiThemeContext.euiTheme.colors.mediumShade,
          '&, span': {
            cursor: 'not-allowed !important'
          },
          '&:hover, &:focus': {
            textDecoration: 'none !important'
          }
        })
      })],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, badgeDescription),
    isOpen: open,
    closePopover: () => setOpen(false),
    panelProps: {
      css: styles.popoverPanel
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, open && /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.graph.fieldManager.fieldSearchPlaceholder', {
        defaultMessage: 'Filter by'
      }),
      compressed: true,
      'data-test-subj': 'graph-field-search'
    },
    listProps: {
      css: styles.selectableList
    },
    searchable: true,
    options: fieldOptions,
    onChange: newOptions => {
      newOptions.forEach(option => {
        if (option.checked === 'on' && !fieldMap[option.label].selected) {
          selectField(option.label);
        } else if (option.checked !== 'on' && fieldMap[option.label].selected) {
          deselectField(option.label);
        }
      });
      setFieldOptions(newOptions);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)));
}
function toOptions(fields) {
  return fields
  // don't show non-aggregatable fields, except for the case when they are already selected.
  // this is necessary to ensure backwards compatibility with existing workspaces that might
  // contain non-aggregatable fields.
  .filter(field => isExplorable(field) || field.selected).map(field => ({
    label: field.name,
    prepend: /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      className: "eui-alignMiddle",
      type: field.type,
      fill: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 18
      }
    }),
    checked: field.selected ? 'on' : undefined
  }));
}
const explorableTypes = ['string', 'number', 'date', 'ip', 'boolean'];
function isExplorable(field) {
  if (!field.aggregatable) {
    return false;
  }
  return explorableTypes.includes(field.type);
}
const styles = {
  popoverPanel: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '350px',
    padding: euiTheme.size.xs
  }),
  selectableList: ({
    euiTheme
  }) => (0, _react2.css)({
    margin: `0 -${euiTheme.size.xs} -${euiTheme.size.xs}`
  })
};