"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamFlyoutWithContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _http = require("../../../../services/http");
var _notification = require("../../../../services/notification");
var _ui_metric = require("../../../../services/ui_metric");
var _services = require("../../../../services");
var _ui_metric2 = require("../../../../../../common/constants/ui_metric");
var _api = require("../../../../services/api");
var _ = require("../../../..");
var _data_stream_detail_panel = require("./data_stream_detail_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/data_stream_list/data_stream_detail_panel/data_stream_flyout_with_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataStreamFlyoutWithContext = ({
  core,
  dependencies,
  datastreamName,
  onClose,
  usageCollection
}) => {
  // this normally happens when the index management app is rendered
  // but if components are embedded elsewhere that setup is skipped, so we have to do it here
  // would do it in plugin.ts but that blows up the bundle size
  // can't do it in an effect because then the first http call fails as the instantiation happens after first render
  if (!_http.httpService.httpClient) {
    _http.httpService.setup(core.http);
    _notification.notificationService.setup(core.notifications);
  }
  _services.documentationService.setup(core.docLinks);
  const uiMetricService = new _ui_metric.UiMetricService(_ui_metric2.UIM_APP_NAME);
  (0, _api.setUiMetricService)(uiMetricService);
  uiMetricService.setup(usageCollection);
  const newDependencies = {
    ...dependencies,
    services: {
      ...(dependencies.services || {}),
      httpService: _http.httpService,
      notificationService: _notification.notificationService,
      uiMetricService
    }
  };
  return /*#__PURE__*/_react.default.createElement(_.IndexManagementAppContext, {
    core: core,
    dependencies: newDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_data_stream_detail_panel.DataStreamDetailPanel, {
    dataStreamName: datastreamName,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.DataStreamFlyoutWithContext = DataStreamFlyoutWithContext;