"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertToLookupIndexModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/convert_to_lookup_index_modal/convert_to_lookup_index_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const convertToLookupIndexSchema = {
  lookupIndexName: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    validations: [{
      validator: ({
        value
      }) => {
        if (!value) {
          return {
            message: _i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexModal.lookupIndexNameRequired', {
              defaultMessage: 'Lookup index name is required'
            })
          };
        }
      }
    }]
  }
};
const ConvertToLookupIndexModal = ({
  onCloseModal,
  onConvert,
  sourceIndexName,
  isConverting = false,
  errorMessage
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onSubmitForm = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid) {
      onConvert(data.lookupIndexName);
    }
  };
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      lookupIndexName: `lookup-${sourceIndexName}`
    },
    schema: convertToLookupIndexSchema,
    id: 'convertToLookupIndexForm'
  });
  const formHasErrors = form.getErrors().length > 0;
  const disableSubmit = formHasErrors || form.isValid === false || isConverting;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => onCloseModal(),
    "data-test-subj": "convertToLookupIndexModal",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.convertToLookupIndexModal.modalHeaderTitle",
    defaultMessage: "Convert index to lookup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.convertToLookupIndexModal.modalBodyDescription",
    defaultMessage: "A new lookup index will be created, and the original index will still exist as before.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    "data-test-subj": "convertToLookupIndexForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexModal.sourceIndexLabel', {
      defaultMessage: 'Source index'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: sourceIndexName,
    disabled: true,
    "data-test-subj": "sourceIndexName",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "lookupIndexName",
    component: _components.TextField,
    label: _i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexModal.lookupIndexNameLabel', {
      defaultMessage: 'Lookup index name'
    }),
    euiFieldProps: {
      'data-test-subj': 'lookupIndexName',
      disabled: isConverting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }), errorMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexModal.errorCalloutTitle', {
      defaultMessage: 'An error has occurred'
    }),
    color: "danger",
    iconType: "error",
    "data-test-subj": "errorCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, errorMessage)))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelButton",
    onClick: () => onCloseModal(),
    disabled: isConverting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.convertToLookupIndexModal.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    isLoading: isConverting,
    "data-test-subj": "convertButton",
    onClick: onSubmitForm,
    disabled: disableSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, isConverting ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.convertToLookupIndexModal.convertingButton",
    defaultMessage: "Converting...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.convertToLookupIndexModal.convertButton",
    defaultMessage: "Convert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }))));
};
exports.ConvertToLookupIndexModal = ConvertToLookupIndexModal;