"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../services");
var _details_page_settings_content = require("./details_page_settings_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DetailsPageSettings = ({
  indexName,
  hasUpdateSettingsPrivilege
}) => {
  const {
    isLoading,
    data,
    error,
    resendRequest
  } = (0, _services.useLoadIndexSettings)(indexName);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.loadingDescription",
      defaultMessage: "Loading index settings\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }));
  }
  if (error || !data) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsSettingsError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.errorTitle",
        defaultMessage: "Unable to load index settings",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.errorDescription",
        defaultMessage: "We encountered an error loading settings for index {indexName}. Make sure that the index name in the URL is correct and try again.",
        values: {
          indexName
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        "data-test-subj": "indexDetailsSettingsReloadButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.reloadButtonLabel",
        defaultMessage: "Reload",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 15
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_details_page_settings_content.DetailsPageSettingsContent, {
    data: data,
    indexName: indexName,
    reloadIndexSettings: resendRequest,
    hasUpdateSettingsPrivilege: hasUpdateSettingsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.DetailsPageSettings = DetailsPageSettings;