"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSettingsWithContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../../../services");
var _ui_metric = require("../../../../../../../common/constants/ui_metric");
var _http = require("../../../../../services/http");
var _notification = require("../../../../../services/notification");
var _ui_metric2 = require("../../../../../services/ui_metric");
var _ = require("../../../../..");
var _details_page_settings = require("../details_page_settings");
var _api = require("../../../../../services/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/with_context_components/index_settings_with_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexSettingsWithContext = ({
  core,
  dependencies,
  indexName,
  usageCollection,
  hasUpdateSettingsPrivilege
}) => {
  // this normally happens when the index management app is rendered
  // but if components are embedded elsewhere that setup is skipped, so we have to do it here
  // would do it in plugin.ts but that blows up the bundle size
  // can't do it in an effect because then the first http call fails as the instantiation happens after first render
  if (!_http.httpService.httpClient) {
    _http.httpService.setup(core.http);
    _notification.notificationService.setup(core.notifications);
  }
  _services.documentationService.setup(core.docLinks);
  const uiMetricService = new _ui_metric2.UiMetricService(_ui_metric.UIM_APP_NAME);
  (0, _api.setUiMetricService)(uiMetricService);
  uiMetricService.setup(usageCollection);
  const newDependencies = {
    ...dependencies,
    services: {
      ...(dependencies.services || {}),
      httpService: _http.httpService,
      notificationService: _notification.notificationService,
      uiMetricService
    }
  };
  return /*#__PURE__*/_react.default.createElement(_.IndexManagementAppContext, {
    core: core,
    dependencies: newDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_details_page_settings.DetailsPageSettings, {
    indexName: indexName,
    hasUpdateSettingsPrivilege: hasUpdateSettingsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.IndexSettingsWithContext = IndexSettingsWithContext;