"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobConfigurationOutdatedCallout = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _recreate_job_callout = require("./recreate_job_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_job_status/job_configuration_outdated_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JobConfigurationOutdatedCallout = ({
  hasSetupCapabilities,
  moduleName,
  onRecreateMlJob
}) => /*#__PURE__*/_react.default.createElement(_recreate_job_callout.RecreateJobCallout, {
  hasSetupCapabilities: hasSetupCapabilities,
  title: _i18n.i18n.translate('xpack.infra.logs.analysis.jobConfigurationOutdatedCalloutTitle', {
    defaultMessage: 'The {moduleName} ML job configuration is outdated',
    values: {
      moduleName
    }
  }),
  onRecreateMlJob: onRecreateMlJob,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.analysis.jobConfigurationOutdatedCalloutMessage",
  defaultMessage: "The {moduleName} ML job was created using a different configuration. Recreate the job to apply the current configuration. This removes previously detected anomalies.",
  values: {
    moduleName
  },
  tagName: "p",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 5
  }
}));
exports.JobConfigurationOutdatedCallout = JobConfigurationOutdatedCallout;