"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../constants");
var _navigation = require("../../services/navigation");
var _manage_processors = require("../manage_processors");
var _empty_list = require("./empty_list");
var _table = require("./table");
var _delete_modal = require("./delete_modal");
var _utils = require("../utils");
var _pipeline_flyout = require("./pipeline_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/main.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getPipelineNameFromLocation = location => {
  const params = new URLSearchParams(location.search);
  return params.get('pipeline');
};
const PipelinesList = ({
  history
}) => {
  var _services$consolePlug;
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const pipelineNameFromLocation = getPipelineNameFromLocation(history.location);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(pipelineNameFromLocation !== null);
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const [pipelinesToDelete, setPipelinesToDelete] = (0, _react.useState)([]);
  const {
    data,
    isLoading,
    error,
    resendRequest
  } = services.api.useLoadPipelines();
  const hasManageProcessorsPrivileges = (0, _manage_processors.useCheckManageProcessorsPrivileges)();
  // Track component loaded
  (0, _react.useEffect)(() => {
    services.metric.trackUiMetric(_constants.UIM_PIPELINES_LIST_LOAD);
    services.breadcrumbs.setBreadcrumbs('home');
  }, [services.metric, services.breadcrumbs]);
  const goToEditPipeline = pipelineName => {
    // this double encoding (+1 in getEditPath) is a
    // temporary workaround for history v4 bug with url-encoded
    // route params see https://github.com/elastic/kibana/issues/234500
    const encodedParam = encodeURIComponent(pipelineName);
    history.push((0, _navigation.getEditPath)({
      pipelineName: encodedParam
    }));
  };
  const goToClonePipeline = clonedPipelineName => {
    // this double encoding (+1 in getClonePath) is a
    // temporary workaround for history v4 bug with url-encoded
    // route params see https://github.com/elastic/kibana/issues/234500
    const encodedParam = encodeURIComponent(clonedPipelineName);
    history.push((0, _navigation.getClonePath)({
      clonedPipelineName: encodedParam
    }));
  };
  const goToCreatePipeline = pipelineName => {
    history.push((0, _navigation.getCreatePath)({
      pipelineName
    }));
  };
  const goHome = () => {
    setShowFlyout(false);

    // When redirecting the user to the list of pipelines, we want to only clean
    // up the pipeline query param as there might be other query params (for example:
    // search or filters) that we want to keep.
    const params = new URLSearchParams(history.location.search);
    params.delete('pipeline');
    history.push({
      pathname: '',
      search: params.toString()
    });
  };
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        "data-test-subj": "pipelineLoadError",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadErrorTitle",
        defaultMessage: "Unable to load pipelines",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      }, (0, _utils.getErrorText)(error)),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadPipelineReloadButton",
        defaultMessage: "Try again",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    });
  }
  if (isLoading && !data) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      "data-test-subj": "sectionLoading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.loadingMessage",
      defaultMessage: "Loading pipelines...",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }));
  }
  if (data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_list.EmptyList, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 12
      }
    });
  }
  const createMenuItems = [
  /**
   * Create pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineButtonLabel', {
      defaultMessage: 'New pipeline'
    }),
    ...(0, _public.reactRouterNavigate)(history, (0, _navigation.getCreatePath)()),
    'data-test-subj': `createNewPipeline`
  },
  /**
   * Create pipeline from CSV
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineFromCsvButtonLabel', {
      defaultMessage: 'New pipeline from CSV'
    }),
    ...(0, _public.reactRouterNavigate)(history, (0, _navigation.getCreateFromCsvPath)()),
    'data-test-subj': `createPipelineFromCsv`
  }];
  const titleActionButtons = [/*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    key: "createPipelinePopover",
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      "data-test-subj": "createPipelineDropdown",
      key: "createPipelineDropdown",
      onClick: () => setShowPopover(previousBool => !previousBool),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineDropdownLabel', {
      defaultMessage: 'Create pipeline'
    })),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      items: createMenuItems
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }))];
  if (services.config.enableManageProcessors && hasManageProcessorsPrivileges) {
    titleActionButtons.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      iconType: "wrench",
      "data-test-subj": "manageProcessorsLink"
    }, (0, _public.reactRouterNavigate)(history, (0, _navigation.getManageProcessorsPath)()), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.manageProcessorsLinkText",
      defaultMessage: "Manage processors",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    })));
  }
  titleActionButtons.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: services.documentation.getIngestNodeUrl(),
    target: "_blank",
    iconType: "question",
    "data-test-subj": "documentationLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.list.pipelinesDocsLinkText",
    defaultMessage: "Documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.listTitle",
      defaultMessage: "Ingest Pipelines",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.pipelinesDescription",
      defaultMessage: "Use ingest pipelines to remove or transform fields, extract values from text, and enrich your data before indexing into Elasticsearch.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 11
      }
    }),
    rightSideItems: titleActionButtons,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_table.PipelineTable, {
    isLoading: isLoading,
    onReloadClick: resendRequest,
    onEditPipelineClick: goToEditPipeline,
    onDeletePipelineClick: setPipelinesToDelete,
    onClonePipelineClick: goToClonePipeline,
    pipelines: data,
    openFlyout: name => {
      const params = new URLSearchParams(history.location.search);
      params.set('pipeline', name);
      history.push({
        pathname: '',
        search: params.toString()
      });
      setShowFlyout(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }), showFlyout && pipelineNameFromLocation && /*#__PURE__*/_react.default.createElement(_pipeline_flyout.PipelineFlyout, {
    ingestPipeline: pipelineNameFromLocation,
    onClose: goHome,
    onCreateClick: goToCreatePipeline,
    onEditClick: goToEditPipeline,
    onCloneClick: goToClonePipeline,
    onDeleteClick: setPipelinesToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }), (pipelinesToDelete === null || pipelinesToDelete === void 0 ? void 0 : pipelinesToDelete.length) > 0 ? /*#__PURE__*/_react.default.createElement(_delete_modal.PipelineDeleteModal, {
    callback: deleteResponse => {
      if (deleteResponse !== null && deleteResponse !== void 0 && deleteResponse.hasDeletedPipelines) {
        // reload pipelines list
        resendRequest();
        goHome();
      }
      setPipelinesToDelete([]);
    },
    pipelinesToDelete: pipelinesToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 9
    }
  }) : null, (_services$consolePlug = services.consolePlugin) !== null && _services$consolePlug !== void 0 && _services$consolePlug.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(services.consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 9
    }
  }) : null);
};
exports.PipelinesList = PipelinesList;