"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/input_control_vis/public/components/editor/field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FieldSelectUi extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "hasUnmounted", void 0);
    (0, _defineProperty2.default)(this, "loadFields", indexPatternId => {
      this.setState({
        isLoading: true,
        fields: [],
        indexPatternId
      }, this.debouncedLoad.bind(null, indexPatternId));
    });
    (0, _defineProperty2.default)(this, "debouncedLoad", _lodash.default.debounce(async indexPatternId => {
      var _this$props$filterFie;
      if (!indexPatternId || indexPatternId.length === 0) {
        return;
      }
      let indexPattern;
      try {
        indexPattern = await this.props.getIndexPattern(indexPatternId);
      } catch (err) {
        // index pattern no longer exists
        return;
      }
      if (this.hasUnmounted) {
        return;
      }

      // props.indexPatternId may be updated before getIndexPattern returns
      // ignore response when fetched index pattern does not match active index pattern
      if (indexPattern.id !== this.state.indexPatternId) {
        return;
      }
      const fieldsByTypeMap = new Map();
      const fields = [];
      indexPattern.fields.filter((_this$props$filterFie = this.props.filterField) !== null && _this$props$filterFie !== void 0 ? _this$props$filterFie : () => true).forEach(field => {
        var _fieldsByTypeMap$get;
        const fieldsList = (_fieldsByTypeMap$get = fieldsByTypeMap.get(field.type)) !== null && _fieldsByTypeMap$get !== void 0 ? _fieldsByTypeMap$get : [];
        fieldsList.push(field.name);
        fieldsByTypeMap.set(field.type, fieldsList);
      });
      fieldsByTypeMap.forEach((fieldsList, fieldType) => {
        fields.push({
          label: fieldType,
          options: fieldsList.sort().map(fieldName => {
            return {
              value: fieldName,
              label: fieldName
            };
          })
        });
      });
      fields.sort((a, b) => {
        if (a.label < b.label) return -1;
        if (a.label > b.label) return 1;
        return 0;
      });
      this.setState({
        isLoading: false,
        fields
      });
    }, 300));
    (0, _defineProperty2.default)(this, "onChange", selectedOptions => {
      this.props.onChange(_lodash.default.get(selectedOptions, '0.value'));
    });
    this.hasUnmounted = false;
    this.state = {
      isLoading: false,
      fields: [],
      indexPatternId: props.indexPatternId
    };
  }
  componentWillUnmount() {
    this.hasUnmounted = true;
  }
  componentDidMount() {
    this.loadFields(this.state.indexPatternId);
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (this.props.indexPatternId !== nextProps.indexPatternId) {
      var _nextProps$indexPatte;
      this.loadFields((_nextProps$indexPatte = nextProps.indexPatternId) !== null && _nextProps$indexPatte !== void 0 ? _nextProps$indexPatte : '');
    }
  }
  render() {
    if (!this.props.indexPatternId || this.props.indexPatternId.trim().length === 0) {
      return null;
    }
    const selectId = `fieldSelect-${this.props.controlIndex}`;
    const selectedOptions = [];
    const {
      intl
    } = this.props;
    if (this.props.fieldName) {
      selectedOptions.push({
        value: this.props.fieldName,
        label: this.props.fieldName
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: selectId,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inputControl.editor.fieldSelect.fieldLabel",
        defaultMessage: "Field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 11
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: intl.formatMessage({
        id: 'inputControl.editor.fieldSelect.selectFieldPlaceholder',
        defaultMessage: 'Select field...'
      }),
      singleSelection: true,
      isLoading: this.state.isLoading,
      options: this.state.fields,
      selectedOptions: selectedOptions,
      onChange: this.onChange,
      "data-test-subj": selectId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }));
  }
}
const FieldSelect = exports.FieldSelect = (0, _i18nReact.injectI18n)(FieldSelectUi);