"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVerification = exports.VerificationProvider = void 0;
var _eui = require("@elastic/eui");
var _constate = _interopRequireDefault(require("constate"));
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _use_kibana = require("./use_kibana");
var _verification_code_form = require("./verification_code_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/interactive_setup/public/use_verification.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const [OuterVerificationProvider, useVerification] = (0, _constate.default)(({
  defaultCode
}) => {
  const codeRef = (0, _react.useRef)(defaultCode);
  const [status, setStatus] = (0, _react.useState)('unknown');
  return {
    status,
    setStatus,
    getCode() {
      return codeRef.current;
    },
    setCode(code) {
      codeRef.current = code;
    }
  };
});
exports.useVerification = useVerification;
const InnerVerificationProvider = ({
  children
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const {
    status,
    setStatus,
    setCode
  } = useVerification();
  (0, _react.useEffect)(() => {
    return http.intercept({
      responseError: error => {
        var _error$response;
        if (((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 403) {
          setStatus('unverified');
          setCode(undefined);
        }
      }
    });
  }, [http]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status === 'unverified' && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => setStatus('unknown'),
    maxWidth: _uiTheme.euiThemeVars.euiBreakpoints.s,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_verification_code_form.VerificationCodeForm, {
    onSuccess: values => {
      setStatus('verified');
      setCode(values.code);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }))), children);
};
const VerificationProvider = ({
  defaultCode,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(OuterVerificationProvider, {
    defaultCode: defaultCode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(InnerVerificationProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, children));
};
exports.VerificationProvider = VerificationProvider;