"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsFeed = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/kibana_overview/public/components/news_feed/news_feed.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  article: {
    '& + article': {
      marginTop: euiTheme.size.l
    },
    '&, header': {
      '& > * + *': {
        marginTop: euiTheme.size.xs
      }
    },
    h3: {
      fontWeight: 'inherit'
    }
  }
});
const NewsFeed = ({
  newsFetchResult
}) => /*#__PURE__*/_react.default.createElement("section", {
  "aria-labelledby": "kbnOverviewNews__title",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "kbnOverviewNews__title",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "kibanaOverview.news.title",
  defaultMessage: "What's new",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement("div", {
  css: styles,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 5
  }
}, newsFetchResult === null || newsFetchResult === void 0 ? void 0 : newsFetchResult.feedItems.slice(0, 3).map(({
  title,
  description,
  linkUrl,
  publishOn
}, index) => /*#__PURE__*/_react.default.createElement("article", {
  key: title,
  "aria-labelledby": `kbnOverviewNews__title${index}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement("header", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  id: `kbnOverviewNews__title${index}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 17
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: linkUrl,
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 19
  }
}, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 17
  }
}, /*#__PURE__*/_react.default.createElement("time", {
  dateTime: publishOn.format('YYYY-MM-DD'),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 19
  }
}, publishOn.format('DD MMMM YYYY'))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 15
  }
}, description))))));
exports.NewsFeed = NewsFeed;