"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.durationOutputOptions = exports.durationInputOptions = exports.DurationRowInputs = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/field-formats-plugin/common");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _prepend_provider = require("../../../../shared_components/prepend_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/formatting/duration_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getNewHumanizeOutputLabel({
  text,
  method
}) {
  if (method === 'humanize') {
    return {
      label: _i18n.i18n.translate('xpack.lens.indexPattern.duration.humanizeLabel', {
        defaultMessage: 'Friendly (approximate)'
      }),
      value: method
    };
  }
  if (method === 'humanizePrecise') {
    return {
      label: _i18n.i18n.translate('xpack.lens.indexPattern.duration.humanizePreciseLabel', {
        defaultMessage: 'Friendly (precise)'
      }),
      value: method
    };
  }
  return {
    label: text,
    value: method
  };
}
const durationOutputOptions = exports.durationOutputOptions = _common.DURATION_OUTPUT_FORMATS.map(getNewHumanizeOutputLabel);
const durationInputOptions = exports.durationInputOptions = _common.DURATION_INPUT_FORMATS.map(({
  text,
  kind
}) => ({
  label: text,
  value: kind
}));
function getSelectedOption(inputValue, list) {
  const option = list.find(({
    value
  }) => inputValue === value);
  return option ? [option] : [];
}
const DurationRowInputs = ({
  testSubjLayout,
  testSubjStart,
  testSubjEnd,
  startValue = 'milliseconds',
  endValue = 'seconds',
  onStartChange,
  onEndChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    prepend: /*#__PURE__*/_react.default.createElement(_prepend_provider.Prepend, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.duration.fromLabel', {
      defaultMessage: 'Convert'
    })),
    isClearable: false,
    options: durationInputOptions,
    selectedOptions: getSelectedOption(startValue, durationInputOptions),
    onChange: ([newStartValue]) => onStartChange(newStartValue.value),
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": testSubjStart,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.duration.convertFromAriaLabel', {
      defaultMessage: 'Convert from unit'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    prepend: /*#__PURE__*/_react.default.createElement(_prepend_provider.Prepend, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.custom.toLabel', {
      defaultMessage: 'To'
    })),
    isClearable: false,
    options: durationOutputOptions,
    selectedOptions: getSelectedOption(endValue, durationOutputOptions),
    onChange: ([newEndChange]) => onEndChange(newEndChange.value),
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": testSubjEnd,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.duration.convertToAriaLabel', {
      defaultMessage: 'Convert to unit'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
};
exports.DurationRowInputs = DurationRowInputs;