"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReducedTimeRange = ReducedTimeRange;
exports.setReducedTimeRange = setReducedTimeRange;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _operations = require("../operations");
var _reduced_time_range_utils = require("../reduced_time_range_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/reduced_time_range.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function setReducedTimeRange(columnId, layer, reducedTimeRange, skipLabelUpdate) {
  const trimmedReducedTimeRange = reducedTimeRange === null || reducedTimeRange === void 0 ? void 0 : reducedTimeRange.trim();
  const currentColumn = layer.columns[columnId];
  const label = currentColumn.customLabel || skipLabelUpdate ? currentColumn.label : (0, _operations.adjustTimeScaleLabelSuffix)(currentColumn.label, currentColumn.timeScale, currentColumn.timeScale, currentColumn.timeShift, currentColumn.timeShift, currentColumn.reducedTimeRange, trimmedReducedTimeRange);
  return {
    ...layer,
    columns: {
      ...layer.columns,
      [columnId]: {
        ...layer.columns[columnId],
        reducedTimeRange: trimmedReducedTimeRange,
        label
      }
    }
  };
}
function isInvalid(value) {
  return value === 'previous' || value === 'invalid';
}
function ReducedTimeRange({
  selectedColumn,
  columnId,
  layer,
  updateLayer,
  indexPattern,
  helpMessage,
  skipLabelUpdate
}) {
  const [localValue, setLocalValue] = (0, _react.useState)(selectedColumn.reducedTimeRange);
  (0, _react.useEffect)(() => {
    setLocalValue(selectedColumn.reducedTimeRange);
  }, [selectedColumn.reducedTimeRange]);
  const selectedOperation = _operations.operationDefinitionMap[selectedColumn.operationType];
  const hasDateHistogram = Object.values(layer.columns).some(c => c.operationType === 'date_histogram');
  if (!selectedOperation.canReduceTimeRange || !selectedColumn.reducedTimeRange && (hasDateHistogram || !indexPattern.timeFieldName)) {
    return null;
  }
  const parsedLocalValue = localValue && (0, _common.parseTimeShift)(localValue);
  const isLocalValueInvalid = Boolean(parsedLocalValue && isInvalid(parsedLocalValue));
  const shouldNotUseReducedTimeRange = Boolean(hasDateHistogram || !indexPattern.timeFieldName);
  function getSelectedOption() {
    if (!localValue) return [];
    const goodPick = _reduced_time_range_utils.reducedTimeRangeOptions.filter(({
      value
    }) => value === localValue);
    if (goodPick.length > 0) return goodPick;
    return [{
      value: localValue,
      label: localValue
    }];
  }
  const label = _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.label', {
    defaultMessage: 'Reduced time range'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    "data-test-subj": "indexPattern-dimension-reducedTimeRange-row",
    label: helpMessage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: helpMessage,
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    })) : label,
    helpText: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.help', {
      defaultMessage: 'Reduces the time range specified in the global time filter from the end of the global time filter.'
    }),
    error: shouldNotUseReducedTimeRange ? _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.notApplicableHelp', {
      defaultMessage: 'Additional time range filter can not be used together with date histogram or without a default time field specified on the data view'
    }) : isLocalValueInvalid ? _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.genericInvalidHelp', {
      defaultMessage: 'Time range value is not valid.'
    }) : undefined,
    isInvalid: isLocalValueInvalid || shouldNotUseReducedTimeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: true,
    "data-test-subj": "indexPattern-dimension-reducedTimeRange",
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRangePlaceholder', {
      defaultMessage: 'Type custom values (e.g. 12m)'
    }),
    options: _reduced_time_range_utils.reducedTimeRangeOptions,
    selectedOptions: getSelectedOption(),
    singleSelection: {
      asPlainText: true
    },
    isInvalid: isLocalValueInvalid,
    onCreateOption: val => {
      const parsedVal = (0, _common.parseTimeShift)(val);
      if (!isInvalid(parsedVal)) {
        updateLayer(setReducedTimeRange(columnId, layer, val, skipLabelUpdate));
      } else {
        setLocalValue(val);
      }
    },
    onChange: choices => {
      if (choices.length === 0) {
        updateLayer(setReducedTimeRange(columnId, layer, '', skipLabelUpdate));
        setLocalValue('');
        return;
      }
      const choice = choices[0].value;
      const parsedVal = (0, _common.parseTimeShift)(choice);
      if (!isInvalid(parsedVal)) {
        updateLayer(setReducedTimeRange(columnId, layer, choice, skipLabelUpdate));
      } else {
        setLocalValue(choice);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })))));
}