"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormBasedDatasource = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class FormBasedDatasource {
  setup(core, {
    fieldFormats: fieldFormatsSetup,
    expressions,
    editorFrame,
    charts
  }) {
    editorFrame.registerDatasource(async () => {
      const {
        getFormBasedDatasource,
        getSuffixFormatter,
        suffixFormatterId
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
      if (!fieldFormatsSetup.has(suffixFormatterId)) {
        const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
        const suffixFormatter = getSuffixFormatter(() => startServices().plugins.fieldFormats.deserialize);
        fieldFormatsSetup.register([suffixFormatter]);
      }
      const [coreStart, {
        dataViewFieldEditor,
        uiActions,
        data,
        fieldFormats,
        dataViews,
        unifiedSearch,
        share
      }] = await core.getStartServices();
      return getFormBasedDatasource({
        core: coreStart,
        fieldFormats,
        storage: new _public.Storage(localStorage),
        data,
        unifiedSearch,
        share,
        dataViews,
        charts,
        dataViewFieldEditor,
        uiActions
      });
    });
  }
}
exports.FormBasedDatasource = FormBasedDatasource;