"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureUsageService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @public */

/** @public */

/**
 * @internal
 */
class FeatureUsageService {
  constructor() {
    (0, _defineProperty2.default)(this, "registrations", []);
  }
  setup() {
    return {
      register: async (featureName, licenseType) => {
        this.registrations.push({
          featureName,
          licenseType
        });
      }
    };
  }
  start({
    http
  }) {
    // Skip registration if on logged-out page
    // NOTE: this only works because the login page does a full-page refresh after logging in
    // If this is ever changed, this code will need to buffer registrations and call them after the user logs in.
    const registrationPromise = http.anonymousPaths.isAnonymous(window.location.pathname) || this.registrations.length === 0 ? Promise.resolve() : http.post('/internal/licensing/feature_usage/register', {
      body: JSON.stringify(this.registrations)
    });
    return {
      notifyUsage: async (featureName, usedAt = Date.now()) => {
        // Skip notification if on logged-out page
        if (http.anonymousPaths.isAnonymous(window.location.pathname)) return;
        // Wait for registrations to complete
        await registrationPromise;
        const lastUsed = (0, _lodash.isDate)(usedAt) ? usedAt.getTime() : usedAt;
        await http.post('/internal/licensing/feature_usage/notify', {
          body: JSON.stringify({
            featureName,
            lastUsed
          })
        });
      }
    };
  }
}
exports.FeatureUsageService = FeatureUsageService;