"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LockManagerService = void 0;
var _lock_manager_client = require("./lock_manager_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class LockManagerService {
  constructor(coreSetup, logger) {
    this.coreSetup = coreSetup;
    this.logger = logger;
  }

  /**
   * Acquires a lock with the given ID and executes the callback function.
   * If the lock is already held by another process, the callback will not be executed.
   *
   * Example usage:
   *
   * const { withLock } = new LockManagerService(coreSetup, logger);
   * await withLock('my_lock', () => {
   *  // perform operation
   * });
   */
  async withLock(lockId, callback, {
    metadata
  } = {}) {
    const [coreStart] = await this.coreSetup.getStartServices();
    const esClient = coreStart.elasticsearch.client.asInternalUser;
    const logger = this.logger.get('lock-manager');
    return (0, _lock_manager_client.withLock)({
      esClient,
      logger,
      lockId,
      metadata
    }, callback);
  }
  async getLock(lockId) {
    const [coreStart] = await this.coreSetup.getStartServices();
    const esClient = coreStart.elasticsearch.client.asInternalUser;
    const logger = this.logger.get('lock-manager');
    return (0, _lock_manager_client.getLock)({
      esClient,
      logger,
      lockId
    });
  }
}
exports.LockManagerService = LockManagerService;