"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMSVectorTileStyle = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
var _ems_vector_tile_style_editor = require("./components/ems_vector_tile_style_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/ems/ems_vector_tile_style.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class EMSVectorTileStyle {
  constructor(descriptor = {
    color: ''
  }) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = EMSVectorTileStyle.createDescriptor(descriptor.color);
  }
  static createDescriptor(color) {
    return {
      type: _constants.LAYER_STYLE_TYPE.EMS_VECTOR_TILE,
      color: color !== null && color !== void 0 ? color : ''
    };
  }
  getType() {
    return _constants.LAYER_STYLE_TYPE.EMS_VECTOR_TILE;
  }
  getColor() {
    return this._descriptor.color;
  }
  renderEditor(onStyleDescriptorChange) {
    const onColorChange = ({
      color
    }) => {
      const styleDescriptor = EMSVectorTileStyle.createDescriptor(color);
      onStyleDescriptorChange(styleDescriptor);
    };
    return /*#__PURE__*/_react.default.createElement(_ems_vector_tile_style_editor.EMSVectorTileStyleEditor, {
      color: this._descriptor.color,
      onColorChange: onColorChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    });
  }
}
exports.EMSVectorTileStyle = EMSVectorTileStyle;