"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorStopsCategorical = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _color_stops_utils = require("./color_stops_utils");
var _i18n = require("@kbn/i18n");
var _color_stops = require("./color_stops");
var _stop_input = require("../stop_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/color/color_stops_categorical.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColorStopsCategorical = ({
  colorStops = [{
    stop: '',
    color: _color_stops_utils.DEFAULT_CUSTOM_COLOR
  }],
  field,
  onChange,
  getValueSuggestions,
  swatches
}) => {
  const getStopError = (stop, index) => {
    let count = 0;
    for (let i = 1; i < colorStops.length; i++) {
      if (colorStops[i].stop === stop && i !== index) {
        count++;
      }
    }
    return count ? _i18n.i18n.translate('xpack.maps.styles.colorStops.categoricalStop.noDupesWarningLabel', {
      defaultMessage: 'Stop values must be unique'
    }) : null;
  };
  const renderStopInput = (stop, onStopChange, index) => {
    const stopValue = typeof stop === 'string' ? stop : '';
    return /*#__PURE__*/_react.default.createElement(_stop_input.StopInput, {
      key: field.getName() // force new component instance when field changes
      ,
      field: field,
      getValueSuggestions: getValueSuggestions,
      value: stopValue,
      onChange: onStopChange,
      dataTestSubj: `colorStopInput${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_color_stops.ColorStops, {
    onChange: onChange,
    colorStops: colorStops,
    isStopsInvalid: _color_stops_utils.isCategoricalStopsInvalid,
    getStopError: getStopError,
    renderStopInput: renderStopInput,
    addNewRow: _color_stops_utils.addCategoricalRow,
    swatches: swatches,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.ColorStopsCategorical = ColorStopsCategorical;
ColorStopsCategorical.propTypes = {
  /**
   * Array of { stop, color }.
   * Stops are any strings
   * Stops cannot include duplicates
   * Colors are color hex strings (3 or 6 character).
   */
  colorStops: _propTypes.default.arrayOf(_propTypes.default.shape({
    stopKey: _propTypes.default.number,
    color: _propTypes.default.string
  })),
  /**
   * Callback for when the color stops changes. Called with { colorStops, isInvalid }
   */
  onChange: _propTypes.default.func.isRequired,
  /**
   * Callback for fetching stop value suggestions. Called with query.
   */
  getValueSuggestions: _propTypes.default.func.isRequired
};